/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker;

import io.vertx.circuitbreaker.RetryPolicy;
import org.junit.Assert;
import org.junit.Test;

public class PredefinedRetryPolicyTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstantDelayNegative() {
        RetryPolicy.constantDelay((long)-1L);
    }

    @Test
    public void testConstantDelay() {
        RetryPolicy retryPolicy = RetryPolicy.constantDelay((long)10L);
        for (int i = 1; i <= 50; ++i) {
            Assert.assertEquals((long)10L, (long)retryPolicy.delay(null, i));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLinearDelayNegative() {
        RetryPolicy.linearDelay((long)-1L, (long)30000L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLinearDelayGreatherThanMax() {
        RetryPolicy.linearDelay((long)50000L, (long)30000L);
    }

    @Test
    public void testLinearDelay() {
        RetryPolicy retryPolicy = RetryPolicy.linearDelay((long)10L, (long)250L);
        for (int i = 1; i <= 50; ++i) {
            long delay = retryPolicy.delay(null, i);
            if (i <= 25) {
                Assert.assertEquals((long)(10 * i), (long)delay);
                continue;
            }
            Assert.assertEquals((long)250L, (long)delay);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExponentialDelayNegative() {
        RetryPolicy.exponentialDelayWithJitter((long)-1L, (long)30000L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExponentialDelayGreatherThanMax() {
        RetryPolicy.exponentialDelayWithJitter((long)50000L, (long)30000L);
    }

    @Test
    public void testExponentialDelayWithJitter() {
        int maxDelay = 30000;
        RetryPolicy retryPolicy = RetryPolicy.exponentialDelayWithJitter((long)3L, (long)maxDelay);
        for (int i = 1; i <= 50; ++i) {
            long delay = retryPolicy.delay(null, i);
            Assert.assertTrue((0L <= delay && delay <= (long)maxDelay ? 1 : 0) != 0);
        }
    }
}

