/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.asserts;

import io.vertx.core.json.JsonObject;
import org.assertj.core.api.AbstractAssert;

public class JsonObjectAssert
extends AbstractAssert<JsonObjectAssert, JsonObject> {
    public JsonObjectAssert(JsonObject actual) {
        super((Object)actual, JsonObjectAssert.class);
    }

    public JsonObjectAssert contains(String field, String value) {
        if (this.actual == null) {
            this.failWithMessage("The given json object is null", new Object[0]);
        } else {
            String contained = ((JsonObject)this.actual).getString(field);
            if (contained == null || !contained.equals(value)) {
                this.failWithMessage("The given json object does not contain `" + field + "`=`" + value + "`: " + ((JsonObject)this.actual).encodePrettily(), new Object[0]);
            }
        }
        return this;
    }

    public JsonObjectAssert contains(String field, long value) {
        if (this.actual == null) {
            this.failWithMessage("The given json object is null", new Object[0]);
        } else {
            Long contained = ((JsonObject)this.actual).getLong(field);
            if (contained == null || !contained.equals(value)) {
                this.failWithMessage("The given json object does not contain `" + field + "`=`" + value + "`: " + ((JsonObject)this.actual).encodePrettily(), new Object[0]);
            }
        }
        return this;
    }

    public JsonObjectAssert contains(String field, double value) {
        if (this.actual == null) {
            this.failWithMessage("The given json object is null", new Object[0]);
        } else {
            Double contained = ((JsonObject)this.actual).getDouble(field);
            if (contained == null || !contained.equals(value)) {
                this.failWithMessage("The given json object does not contain `" + field + "`=`" + value + "`: " + ((JsonObject)this.actual).encodePrettily(), new Object[0]);
            }
        }
        return this;
    }
}

