/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.OpenCircuitException;
import io.vertx.circuitbreaker.TimeoutException;
import io.vertx.circuitbreaker.impl.CircuitBreakerImpl;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CircuitBreakerImplTest {
    private Vertx vertx;
    private CircuitBreaker breaker;
    @Rule
    public RepeatRule rule = new RepeatRule();

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        if (this.breaker != null) {
            this.breaker.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void testCreationWithDefault() {
        this.breaker = CircuitBreaker.create((String)"name", (Vertx)this.vertx);
        Assertions.assertThat((String)this.breaker.name()).isEqualTo((Object)"name");
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test
    @Repeat(value=5)
    public void testOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean operationCalled = new AtomicBoolean();
        AtomicReference completionCalled = new AtomicReference();
        this.breaker.execute(fut -> {
            operationCalled.set(true);
            fut.complete((Object)"hello");
        }).onComplete(ar -> completionCalled.set(ar.result()));
        Awaitility.await().until(operationCalled::get);
        Awaitility.await().until(() -> ((String)completionCalled.get()).equalsIgnoreCase("hello"));
    }

    @Test
    @Repeat(value=5)
    public void testWithCustomPredicateOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx).failurePolicy(ar -> ar.failed() && !(ar.cause() instanceof NoStackTraceThrowable));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean operationCalled = new AtomicBoolean();
        AtomicReference completionCalled = new AtomicReference();
        this.breaker.execute(fut -> {
            operationCalled.set(true);
            fut.fail("some fake exception");
        }).onComplete(ar -> {
            completionCalled.set(ar.cause().getMessage());
            Assertions.assertThat((boolean)ar.failed()).isTrue();
        });
        Awaitility.await().until(operationCalled::get);
        Awaitility.await().until(() -> ((String)completionCalled.get()).equalsIgnoreCase("some fake exception"));
    }

    @Test
    @Repeat(value=5)
    public void testWithUserFutureOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean operationCalled = new AtomicBoolean();
        AtomicReference completionCalled = new AtomicReference();
        Promise userFuture = Promise.promise();
        userFuture.future().onComplete(ar -> completionCalled.set(ar.result()));
        this.breaker.executeAndReport(userFuture, fut -> {
            operationCalled.set(true);
            fut.complete((Object)"hello");
        });
        Awaitility.await().until(operationCalled::get);
        Awaitility.await().until(() -> ((String)completionCalled.get()).equalsIgnoreCase("hello"));
    }

    @Test
    @Repeat(value=5)
    public void testWithUserFutureWithCustomPredicateOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx).failurePolicy(ar -> ar.failed() && !(ar.cause() instanceof NoStackTraceThrowable));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean operationCalled = new AtomicBoolean();
        AtomicReference completionCalled = new AtomicReference();
        Promise userFuture = Promise.promise();
        userFuture.future().onComplete(ar -> {
            completionCalled.set(ar.cause().getMessage());
            Assertions.assertThat((boolean)ar.failed()).isTrue();
        });
        this.breaker.executeAndReport(userFuture, fut -> {
            operationCalled.set(true);
            fut.fail("some custom exception");
        });
        Awaitility.await().until(operationCalled::get);
        Awaitility.await().until(() -> ((String)completionCalled.get()).equalsIgnoreCase("some custom exception"));
    }

    @Test
    public void testAsynchronousOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean called = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        this.breaker.execute(future -> this.vertx.setTimer(100L, l -> {
            called.set(true);
            future.complete((Object)"hello");
        })).onComplete(ar -> result.set(ar.result()));
        Awaitility.await().until(called::get);
        Awaitility.await().untilAtomic(result, Is.is((Object)"hello"));
    }

    @Test
    public void testAsynchronousWithCustomPredicateOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx).failurePolicy(ar -> ar.failed() && !(ar.cause() instanceof NoStackTraceThrowable));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean called = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        this.breaker.execute(future -> this.vertx.setTimer(100L, l -> {
            called.set(true);
            future.fail("some custom exception");
        })).onComplete(ar -> {
            result.set(ar.cause().getMessage());
            Assertions.assertThat((boolean)ar.failed()).isTrue();
        });
        Awaitility.await().until(called::get);
        Awaitility.await().untilAtomic(result, Is.is((Object)"some custom exception"));
    }

    @Test
    public void testAsynchronousWithUserFutureOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean called = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        Promise userFuture = Promise.promise();
        userFuture.future().onComplete(ar -> result.set(ar.result()));
        this.breaker.executeAndReport(userFuture, future -> this.vertx.setTimer(100L, l -> {
            called.set(true);
            future.complete((Object)"hello");
        }));
        Awaitility.await().until(called::get);
        Awaitility.await().untilAtomic(result, Is.is((Object)"hello"));
    }

    @Test
    public void testAsynchronousWithUserFutureAndWithCustomPredicateOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx).failurePolicy(ar -> ar.failed() && ar.cause() instanceof ClassNotFoundException);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicBoolean called = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        Promise userFuture = Promise.promise();
        userFuture.future().onComplete(ar -> {
            result.set(ar.cause().getMessage());
            Assertions.assertThat((boolean)ar.failed()).isTrue();
        });
        this.breaker.executeAndReport(userFuture, future -> this.vertx.setTimer(100L, l -> {
            called.set(true);
            future.fail((Throwable)new NullPointerException("some custom exception"));
        }));
        Awaitility.await().until(called::get);
        Awaitility.await().untilAtomic(result, Is.is((Object)"some custom exception"));
    }

    @Test
    public void testRollingWindowFailuresAreDecreased() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(10).setFailuresRollingWindow(10000L));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        IntStream.range(0, 9).forEach(i -> this.breaker.execute(v -> v.fail((Throwable)new RuntimeException("oh no, but this is expected"))));
        Awaitility.await().until(() -> this.breaker.failureCount() == 9L);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        Awaitility.await().atMost(11L, TimeUnit.SECONDS).until(() -> this.breaker.failureCount() < 9L);
        Assertions.assertThat((long)this.breaker.failureCount()).isLessThan(9L);
    }

    @Test
    @Repeat(value=5)
    public void testOpenAndCloseHandler() {
        AtomicInteger spyOpen = new AtomicInteger();
        AtomicInteger spyClosed = new AtomicInteger();
        AtomicReference lastException = new AtomicReference();
        this.breaker = CircuitBreaker.create((String)"name", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setResetTimeout(-1L)).openHandler(v -> spyOpen.incrementAndGet()).closeHandler(v -> spyClosed.incrementAndGet());
        Assertions.assertThat((int)spyOpen.get()).isEqualTo(0);
        Assertions.assertThat((int)spyClosed.get()).isEqualTo(0);
        this.breaker.execute(v -> {
            throw new RuntimeException("oh no, but this is expected");
        }).onComplete(ar -> lastException.set(ar.cause()));
        Assertions.assertThat((int)spyOpen.get()).isEqualTo(0);
        Assertions.assertThat((int)spyClosed.get()).isEqualTo(0);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Assertions.assertThat((Throwable)((Throwable)lastException.get())).isNotNull();
        lastException.set(null);
        for (int i = 1; i < 5; ++i) {
            this.breaker.execute(v -> {
                throw new RuntimeException("oh no, but this is expected");
            }).onComplete(ar -> lastException.set(ar.cause()));
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Assertions.assertThat((int)spyOpen.get()).isEqualTo(1);
        Assertions.assertThat((Throwable)((Throwable)lastException.get())).isNotNull();
        ((CircuitBreakerImpl)this.breaker).reset(true);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        Assertions.assertThat((int)spyOpen.get()).isEqualTo(1);
        Assertions.assertThat((int)spyClosed.get()).isEqualTo(1);
    }

    @Test
    @Repeat(value=5)
    public void testHalfOpen() {
        AtomicBoolean thrown = new AtomicBoolean(false);
        Context ctx = this.vertx.getOrCreateContext().exceptionHandler(ex -> thrown.set(true));
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setResetTimeout(200L).setMaxFailures(1));
        Handler fail = p -> p.fail("fail");
        Handler success = Promise::complete;
        ctx.runOnContext(v -> {
            this.breaker.execute(fail);
            this.breaker.execute(fail);
        });
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        ctx.runOnContext(v -> this.breaker.execute(fail));
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        ctx.runOnContext(v -> this.breaker.execute(success));
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Assertions.assertThat((boolean)thrown.get()).isFalse();
    }

    @Test
    @Repeat(value=5)
    public void testExceptionOnSynchronousCode() {
        AtomicBoolean called = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setFallbackOnFailure(false).setResetTimeout(-1L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(t -> {
            called.set(true);
            return "fallback";
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(v -> {
                throw new RuntimeException("oh no, but this is expected");
            });
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(false);
        AtomicBoolean spy = new AtomicBoolean();
        this.breaker.execute(v -> spy.set(true));
        Assertions.assertThat((boolean)spy.get()).isEqualTo(false);
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
    }

    @Test
    @Repeat(value=5)
    public void testExceptionOnSynchronousCodeWithExecute() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setFallbackOnFailure(false).setResetTimeout(-1L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(t -> "fallback");
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            Promise future = Promise.promise();
            AtomicReference result = new AtomicReference();
            this.breaker.executeAndReport(future, v -> {
                throw new RuntimeException("oh no, but this is expected");
            });
            future.future().onComplete(ar -> result.set(ar.result()));
            Assertions.assertThat((String)((String)result.get())).isNull();
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        AtomicBoolean spy = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        Promise fut = Promise.promise();
        fut.future().onComplete(ar -> result.set(ar.result()));
        this.breaker.executeAndReport(fut, v -> spy.set(true));
        Assertions.assertThat((boolean)spy.get()).isEqualTo(false);
        Assertions.assertThat((String)((String)result.get())).isEqualTo((Object)"fallback");
    }

    @Test
    public void testFailureOnAsynchronousCode() {
        AtomicBoolean called = new AtomicBoolean(false);
        AtomicReference result = new AtomicReference();
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(-1L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> this.vertx.setTimer(100L, l -> future.fail("expected failure"))).onComplete(ar -> result.set(ar.result()));
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(false);
        AtomicBoolean spy = new AtomicBoolean();
        this.breaker.execute(future -> this.vertx.setTimer(100L, l -> {
            future.fail("expected failure");
            spy.set(true);
        })).onComplete(ar -> result.set(ar.result()));
        Awaitility.await().untilAtomic(called, Is.is((Object)true));
        Assertions.assertThat((boolean)spy.get()).isEqualTo(false);
        Assertions.assertThat((String)((String)result.get())).isEqualTo((Object)"fallback");
    }

    @Test
    public void testFailureOnAsynchronousCodeWithCustomPredicate() {
        AtomicBoolean called = new AtomicBoolean(false);
        AtomicReference result = new AtomicReference();
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(-1L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        }).failurePolicy(ar -> ar.failed() && ar.cause() instanceof NoStackTraceThrowable);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> this.vertx.setTimer(100L, l -> future.fail("expected failure"))).onComplete(ar -> result.set(ar.result()));
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        Assertions.assertThat((boolean)called.get()).isFalse();
        AtomicBoolean spy = new AtomicBoolean();
        this.breaker.execute(future -> this.vertx.setTimer(100L, l -> {
            future.fail("expected failure");
            spy.set(true);
        })).onComplete(ar -> result.set(ar.result()));
        Awaitility.await().untilAtomic(called, Is.is((Object)true));
        Assertions.assertThat((boolean)spy.get()).isEqualTo(false);
        Assertions.assertThat((String)((String)result.get())).isEqualTo((Object)"fallback");
    }

    @Test
    @Repeat(value=5)
    public void testResetAttempt() {
        AtomicBoolean called = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(100L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(v -> {
                throw new RuntimeException("oh no, but this is expected");
            });
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(false);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        AtomicBoolean spy = new AtomicBoolean();
        this.breaker.execute(v -> {
            spy.set(true);
            v.complete();
        });
        Assertions.assertThat((boolean)spy.get()).isEqualTo(true);
        Assertions.assertThat((boolean)called.get()).isEqualTo(false);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test
    @Repeat(value=5)
    public void testResetAttemptThatFails() {
        AtomicBoolean called = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(100L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        });
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(v -> {
                throw new RuntimeException("oh no, but this is expected");
            });
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        called.set(false);
        AtomicReference result = new AtomicReference();
        this.breaker.execute(v -> {
            throw new RuntimeException("oh no, but this is expected");
        }).onComplete(ar -> result.set(ar.result()));
        Awaitility.await().until(called::get);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Assertions.assertThat((String)((String)result.get())).isEqualTo((Object)"fallback");
    }

    @Test
    public void testTimeout() {
        AtomicBoolean called = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setTimeout(100L);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger failureCount = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(v -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                v.complete((Object)"done");
            }).onComplete(ar -> {
                if (ar.failed()) {
                    failureCount.incrementAndGet();
                }
            });
        }
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(false);
        Assertions.assertThat((int)failureCount.get()).isEqualTo(options.getMaxFailures());
        AtomicBoolean spy = new AtomicBoolean();
        AtomicReference result = new AtomicReference();
        this.breaker.execute(v -> {
            spy.set(true);
            v.complete();
        }).onComplete(ar -> result.set(ar.result()));
        Assertions.assertThat((boolean)spy.get()).isEqualTo(false);
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Assertions.assertThat((String)((String)result.get())).isEqualTo((Object)"fallback");
    }

    @Test
    public void testTimeoutWithFallbackCalled() {
        AtomicBoolean called = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setTimeout(100L).setResetTimeout(5000L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures() + 3; ++i) {
            this.breaker.execute(v -> {
                try {
                    Thread.sleep(500L);
                    v.complete((Object)"done");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    v.fail((Throwable)e);
                }
            }).onComplete(ar -> {
                if (ar.result().equals("fallback")) {
                    count.incrementAndGet();
                }
            });
        }
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Assertions.assertThat((int)count.get()).isEqualTo(options.getMaxFailures() + 3);
    }

    @Test
    public void testResetAttemptOnTimeout() {
        AtomicBoolean called = new AtomicBoolean(false);
        AtomicBoolean hasBeenOpened = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(100L).setTimeout(10L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        }).openHandler(v -> hasBeenOpened.set(true));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> {});
        }
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)true));
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        called.set(false);
        this.breaker.execute(Promise::complete);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Awaitility.await().untilAtomic(called, Is.is((Object)false));
    }

    @Test
    @Repeat(value=10)
    public void testResetAttemptThatFailsOnTimeout() {
        int i;
        AtomicBoolean called = new AtomicBoolean(false);
        AtomicBoolean hasBeenOpened = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(100L).setTimeout(10L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        }).openHandler(v -> hasBeenOpened.set(true));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> {});
        }
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)true));
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        hasBeenOpened.set(false);
        called.set(false);
        this.breaker.execute(future -> {});
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Awaitility.await().untilAtomic(called, Is.is((Object)true));
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)true));
        hasBeenOpened.set(false);
        called.set(false);
        this.breaker.execute(future -> {});
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        Awaitility.await().untilAtomic(called, Is.is((Object)true));
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)true));
        hasBeenOpened.set(false);
        called.set(false);
        hasBeenOpened.set(false);
        called.set(false);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED || this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        this.breaker.execute(Promise::complete);
        Awaitility.await().until(() -> {
            if (this.breaker.state() == CircuitBreakerState.CLOSED) {
                return true;
            }
            this.breaker.execute(Promise::complete);
            return false;
        });
        called.set(false);
        for (i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(f -> f.complete(null));
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)false));
    }

    @Test
    public void testThatOnlyOneRequestIsCheckedInHalfOpen() {
        AtomicBoolean called = new AtomicBoolean(false);
        AtomicBoolean hasBeenOpened = new AtomicBoolean(false);
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(1000L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(v -> {
            called.set(true);
            return "fallback";
        }).openHandler(v -> hasBeenOpened.set(true));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> future.fail("expected failure"));
        }
        Awaitility.await().untilAtomic(hasBeenOpened, Is.is((Object)true));
        Assertions.assertThat((boolean)called.get()).isEqualTo(true);
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.HALF_OPEN);
        called.set(false);
        AtomicInteger fallbackCalled = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.executeWithFallback(future -> this.vertx.setTimer(500L, l -> future.complete()), v -> {
                fallbackCalled.incrementAndGet();
                return "fallback";
            });
        }
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.CLOSED);
        Assertions.assertThat((int)fallbackCalled.get()).isEqualTo(options.getMaxFailures() - 1);
    }

    @Test
    public void testFailureWhenThereIsNoFallback() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(50000L).setTimeout(300L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        ArrayList results = new ArrayList();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> future.fail("expected failure")).onComplete(results::add);
        }
        Awaitility.await().until(() -> results.size() == options.getMaxFailures());
        results.forEach(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).hasMessage("expected failure");
        });
        results.clear();
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        this.breaker.execute(future -> future.fail("expected failure")).onComplete(results::add);
        Awaitility.await().until(() -> results.size() == 1);
        results.forEach(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).isInstanceOf(OpenCircuitException.class)).hasMessage("open circuit");
        });
        ((CircuitBreakerImpl)this.breaker).reset(true);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        results.clear();
        this.breaker.execute(future -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).onComplete(results::add);
        Awaitility.await().until(() -> results.size() == 1);
        results.forEach(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            Assertions.assertThat((Throwable)ar.cause()).isInstanceOf(TimeoutException.class);
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).hasMessage("operation timeout");
        });
    }

    @Test
    public void testWhenFallbackThrowsAnException() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(5000L).setFallbackOnFailure(true);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        ArrayList results = new ArrayList();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.executeWithFallback(future -> future.fail("expected failure"), t -> {
                throw new RuntimeException("boom");
            }).onComplete(results::add);
        }
        Awaitility.await().until(() -> results.size() == options.getMaxFailures());
        results.forEach(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).hasMessage("boom");
        });
        results.clear();
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        this.breaker.executeWithFallback(future -> future.fail("expected failure"), t -> {
            throw new RuntimeException("boom");
        }).onComplete(results::add);
        Awaitility.await().until(() -> results.size() == 1);
        results.forEach(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).hasMessage("boom");
        });
    }

    @Test
    public void testTheExceptionReceivedByFallback() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setResetTimeout(50000L).setTimeout(300L).setFallbackOnFailure(true);
        ArrayList failures = new ArrayList();
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options).fallback(failures::add);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> future.fail("expected failure"));
        }
        Awaitility.await().until(() -> failures.size() == options.getMaxFailures());
        failures.forEach(ar -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar).isNotNull()).hasMessage("expected failure"));
        failures.clear();
        ((CircuitBreakerImpl)this.breaker).reset(true);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        failures.clear();
        this.breaker.execute(future -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Awaitility.await().until(() -> failures.size() == 1);
        failures.forEach(ar -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar).isNotNull()).isInstanceOf(TimeoutException.class)).hasMessage("operation timeout"));
        ((CircuitBreakerImpl)this.breaker).reset(true);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        failures.clear();
        this.breaker.execute(future -> {
            throw new RuntimeException("boom");
        });
        Awaitility.await().until(() -> failures.size() == 1);
        failures.forEach(ar -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar).isNotNull()).hasMessage("boom"));
    }

    @Test
    @Repeat(value=5)
    public void testRetries() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setMaxRetries(5).setMaxFailures(4).setTimeout(100L).setFallbackOnFailure(true);
        ArrayList failures = new ArrayList();
        AtomicInteger calls = new AtomicInteger();
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        AtomicReference result = new AtomicReference();
        this.vertx.runOnContext(v -> result.set(this.breaker.execute(future -> {
            calls.incrementAndGet();
            future.fail("boom");
        })));
        Awaitility.await().untilAtomic(calls, Is.is((Object)6));
        Assertions.assertThat((boolean)((Future)result.get()).failed()).isTrue();
        Assertions.assertThat((long)this.breaker.failureCount()).isEqualTo(1L);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        ((CircuitBreakerImpl)this.breaker).reset(true);
        calls.set(0);
        result.set(null);
        this.vertx.runOnContext(v -> result.set(this.breaker.execute(future -> {
            if (calls.incrementAndGet() >= 4) {
                future.complete();
            } else {
                future.fail("boom");
            }
        })));
        Awaitility.await().untilAtomic(calls, Is.is((Object)4));
        Assertions.assertThat((boolean)((Future)result.get()).succeeded()).isTrue();
        Assertions.assertThat((long)this.breaker.failureCount()).isEqualTo(0L);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        ((CircuitBreakerImpl)this.breaker).reset(true);
        calls.set(0);
        this.vertx.runOnContext(v -> {
            for (int i = 0; i < options.getMaxFailures() + 1; ++i) {
                this.breaker.execute(future -> {
                    try {
                        calls.incrementAndGet();
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        });
        Awaitility.await().until(() -> this.breaker.state() == CircuitBreakerState.OPEN);
        calls.set(0);
        ((CircuitBreakerImpl)this.breaker).reset(true);
        AtomicReference result2 = new AtomicReference();
        this.vertx.runOnContext(v -> {
            result2.set(this.breaker.execute(future -> {
                if (calls.incrementAndGet() == 4) {
                    future.complete();
                } else {
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }));
            for (int i = 0; i < options.getMaxFailures(); ++i) {
                this.breaker.execute(future -> future.fail("boom"));
            }
        });
        Awaitility.await().until(() -> result2.get() != null && ((Future)result2.get()).failed());
        Assertions.assertThat((long)this.breaker.failureCount()).isGreaterThanOrEqualTo((long)(options.getMaxFailures() + 1));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        ((CircuitBreakerImpl)this.breaker).reset(true);
        this.breaker.fallback(failures::add);
        calls.set(0);
        result.set(null);
        this.vertx.runOnContext(v -> result.set(this.breaker.execute(future -> {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        })));
        Awaitility.await().until(() -> failures.size() == 1);
        failures.forEach(ar -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar).isNotNull()).isInstanceOf(TimeoutException.class)).hasMessage("operation timeout"));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        ((CircuitBreakerImpl)this.breaker).reset(true);
        calls.set(0);
        result.set(null);
        this.vertx.runOnContext(v -> result.set(this.breaker.execute(future -> {
            if (calls.incrementAndGet() == 4) {
                future.complete();
            } else {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        })));
        Awaitility.await().untilAtomic(calls, Is.is((Object)4));
        Assertions.assertThat((boolean)((Future)result.get()).succeeded()).isTrue();
        Assertions.assertThat((long)this.breaker.failureCount()).isEqualTo(0L);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBucketSize() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setNotificationAddress("vertx.circuit-breaker").setMetricsRollingBuckets(7);
        CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
    }

    @Test
    public void operationTimersShouldBeRemovedToAvoidOOM(TestContext ctx) {
        this.breaker = CircuitBreaker.create((String)"cb", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setTimeout(600000L));
        Async async = ctx.async(3000);
        long id = this.vertx.setPeriodic(1L, l -> this.breaker.execute(prom -> prom.complete((Object)new byte[0xA00000])).onSuccess(v -> async.countDown()).onFailure(arg_0 -> ((TestContext)ctx).fail(arg_0)));
        async.await();
    }
}

