/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.circuitbreaker.asserts.Assertions;
import io.vertx.circuitbreaker.impl.CircuitBreakerImpl;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CircuitBreakerMetricsTest {
    private Vertx vertx;
    private CircuitBreaker breaker;
    @Rule
    public RepeatRule rule = new RepeatRule();

    @Before
    public void setUp(TestContext tc) {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(tc.exceptionHandler());
    }

    @After
    public void tearDown() {
        this.vertx.exceptionHandler(null);
        if (this.breaker != null) {
            this.breaker.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    @Repeat(value=10)
    public void testWithSuccessfulCommands(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions());
        Async async = tc.async();
        Future command1 = this.breaker.execute(this.commandThatWorks());
        Future command2 = this.breaker.execute(this.commandThatWorks());
        Future command3 = this.breaker.execute(this.commandThatWorks());
        CompositeFuture.all((Future)command1, (Future)command2, (Future)command3).onComplete(ar -> {
            Assertions.assertThat(ar).succeeded();
            Assertions.assertThat(this.metrics()).contains("name", "some-circuit-breaker").contains("state", CircuitBreakerState.CLOSED.name()).contains("failures", 0L).contains("totalErrorCount", 0L).contains("totalSuccessCount", 3L).contains("totalTimeoutCount", 0L).contains("totalExceptionCount", 0L).contains("totalFailureCount", 0L).contains("totalOperationCount", 3L).contains("totalSuccessPercentage", 100L).contains("totalErrorPercentage", 0L);
            async.complete();
        });
    }

    private CircuitBreakerOptions getOptions() {
        return new CircuitBreakerOptions().setNotificationAddress("vertx.circuit-breaker");
    }

    @Test
    @Repeat(value=10)
    public void testWithFailedCommands(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions());
        Async async = tc.async();
        Future command1 = this.breaker.execute(this.commandThatFails());
        Future command2 = this.breaker.execute(this.commandThatWorks());
        Future command3 = this.breaker.execute(this.commandThatWorks());
        Future command4 = this.breaker.execute(this.commandThatFails());
        CompositeFuture.join((Future)command1, (Future)command2, (Future)command3, (Future)command4).onComplete(ar -> {
            Assertions.assertThat(this.metrics()).contains("name", "some-circuit-breaker").contains("state", CircuitBreakerState.CLOSED.name()).contains("totalErrorCount", 2L).contains("totalSuccessCount", 2L).contains("totalTimeoutCount", 0L).contains("totalExceptionCount", 0L).contains("totalFailureCount", 2L).contains("totalOperationCount", 4L).contains("totalSuccessPercentage", 50L).contains("totalErrorPercentage", 50L);
            async.complete();
        });
    }

    @Test
    @Repeat(value=10)
    public void testWithCrashingCommands(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions());
        Async async = tc.async();
        Future command1 = this.breaker.execute(this.commandThatFails());
        Future command2 = this.breaker.execute(this.commandThatWorks());
        Future command3 = this.breaker.execute(this.commandThatWorks());
        Future command4 = this.breaker.execute(this.commandThatFails());
        Future command5 = this.breaker.execute(this.commandThatCrashes());
        CompositeFuture.join((Future)command1, (Future)command2, (Future)command3, (Future)command4, (Future)command5).onComplete(ar -> {
            Assertions.assertThat(this.metrics()).contains("name", "some-circuit-breaker").contains("state", CircuitBreakerState.CLOSED.name()).contains("totalErrorCount", 3L).contains("totalSuccessCount", 2L).contains("totalTimeoutCount", 0L).contains("totalExceptionCount", 1L).contains("totalFailureCount", 2L).contains("totalOperationCount", 5L).contains("totalSuccessPercentage", 40.0).contains("totalErrorPercentage", 60.0);
            async.complete();
        });
    }

    @Test
    @Repeat(value=10)
    public void testWithTimeoutCommands(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions().setTimeout(100L));
        Async async = tc.async();
        Future command1 = this.breaker.execute(this.commandThatFails());
        Future command2 = this.breaker.execute(this.commandThatWorks());
        Future command3 = this.breaker.execute(this.commandThatWorks());
        Future command4 = this.breaker.execute(this.commandThatFails());
        Future command5 = this.breaker.execute(this.commandThatTimeout(100));
        CompositeFuture.join((Future)command1, (Future)command2, (Future)command3, (Future)command4, (Future)command5).onComplete(ar -> {
            Assertions.assertThat(this.metrics()).contains("name", "some-circuit-breaker").contains("state", CircuitBreakerState.CLOSED.name()).contains("totalErrorCount", 3L).contains("totalSuccessCount", 2L).contains("totalTimeoutCount", 1L).contains("totalExceptionCount", 0L).contains("totalFailureCount", 2L).contains("totalOperationCount", 5L).contains("totalSuccessPercentage", 40.0).contains("totalErrorPercentage", 60.0);
            async.complete();
        });
    }

    @Test
    @Repeat(value=10)
    public void testLatencyComputation(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions());
        Async async = tc.async();
        int count = 1000;
        IntStream.range(0, count).mapToObj(i -> this.breaker.execute(this.commandThatWorks())).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all)).onComplete(ar -> {
            Assertions.assertThat(ar).succeeded();
            Assertions.assertThat(this.metrics()).contains("name", "some-circuit-breaker").contains("state", CircuitBreakerState.CLOSED.name()).contains("failures", 0L).contains("totalErrorCount", 0L).contains("totalSuccessCount", count).contains("totalTimeoutCount", 0L).contains("totalExceptionCount", 0L).contains("totalFailureCount", 0L).contains("totalOperationCount", count).contains("totalSuccessPercentage", 100L).contains("totalErrorPercentage", 0L);
            org.assertj.core.api.Assertions.assertThat((Integer)this.metrics().getInteger("totalLatencyMean")).isNotZero();
            async.complete();
        });
    }

    @Test
    @Repeat(value=100)
    public void testEviction(TestContext tc) {
        this.breaker = CircuitBreaker.create((String)"some-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)this.getOptions().setMetricsRollingWindow(10L));
        Async async = tc.async();
        int count = 1000;
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < count; ++i) {
            list.add(this.breaker.execute(this.commandThatWorks()));
        }
        CompositeFuture.all(list).onComplete(ar -> {
            Assertions.assertThat(ar).succeeded();
            org.assertj.core.api.Assertions.assertThat((Integer)this.metrics().getInteger("totalOperationCount")).isEqualTo(1000);
            org.assertj.core.api.Assertions.assertThat((Integer)this.metrics().getInteger("rollingOperationCount")).isLessThanOrEqualTo(1000);
            async.complete();
        });
    }

    private Handler<Promise<Void>> commandThatWorks() {
        return future -> this.vertx.setTimer(5L, l -> future.complete(null));
    }

    private Handler<Promise<Void>> commandThatFails() {
        return future -> this.vertx.setTimer(5L, l -> future.fail("expected failure"));
    }

    private Handler<Promise<Void>> commandThatCrashes() {
        return future -> {
            throw new RuntimeException("Expected error");
        };
    }

    private Handler<Promise<Void>> commandThatTimeout(int timeout) {
        return future -> this.vertx.setTimer((long)(timeout + 500), l -> future.complete(null));
    }

    private JsonObject metrics() {
        return ((CircuitBreakerImpl)this.breaker).getMetrics();
    }
}

