/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CircuitBreakerWithHTTPTest {
    private Vertx vertx;
    private HttpServer http;
    private HttpClient client;
    private CircuitBreaker breaker;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        Router router = Router.router((Vertx)this.vertx);
        router.route(HttpMethod.GET, "/").handler(ctxt -> ctxt.response().setStatusCode(200).end("hello"));
        router.route(HttpMethod.GET, "/error").handler(ctxt -> ctxt.response().setStatusCode(500).end("failed !"));
        router.route(HttpMethod.GET, "/long").handler(ctxt -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctxt.response().setStatusCode(200).end("hello");
        });
        AtomicBoolean invoked = new AtomicBoolean();
        router.route(HttpMethod.GET, "/flaky").handler(ctxt -> {
            if (invoked.compareAndSet(false, true)) {
                ctxt.response().setStatusCode(503).putHeader(HttpHeaders.RETRY_AFTER, (CharSequence)"2").end();
            } else {
                ctxt.response().setStatusCode(200).end();
            }
        });
        AtomicBoolean done = new AtomicBoolean();
        this.http = this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        this.client = this.vertx.createHttpClient();
    }

    @After
    public void tearDown() {
        if (this.breaker != null) {
            this.breaker.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.http.close(ar -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        completed.set(false);
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        this.client.close();
    }

    @Test
    public void testOk() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions());
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        Promise result = Promise.promise();
        this.breaker.executeAndReport(result, v -> this.client.request(HttpMethod.GET, 8080, "localhost", "/").compose(req -> req.send().compose(resp -> resp.body().map(Buffer::toString))).onComplete((Handler)v));
        Awaitility.await().until(() -> result.future().result() != null);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
    }

    @Test
    public void testFailure() {
        CircuitBreakerOptions options = new CircuitBreakerOptions();
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            Promise result = Promise.promise();
            this.breaker.executeAndReport(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/error").compose(req -> req.send().compose(resp -> Future.succeededFuture((Object)resp.statusCode()))).onSuccess(sc -> {
                if (sc != 200) {
                    future.fail("http error");
                } else {
                    future.complete();
                }
                count.incrementAndGet();
            }));
        }
        Awaitility.await().untilAtomic(count, Is.is((Object)options.getMaxFailures()));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Promise result = Promise.promise();
        this.breaker.executeAndReportWithFallback(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/error").compose(req -> req.send().compose(resp -> Future.succeededFuture((Object)resp.statusCode()))).onSuccess(sc -> {
            if (sc != 200) {
                future.fail("http error");
            } else {
                future.complete();
            }
        }), v -> "fallback");
        Awaitility.await().until(() -> ((String)result.future().result()).equals("fallback"));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
    }

    @Test
    public void testTimeout() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setTimeout(100L).setMaxFailures(2);
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)options);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < options.getMaxFailures(); ++i) {
            this.breaker.execute(future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/long").compose(req -> req.send().compose(HttpClientResponse::body).onSuccess(body -> {
                count.incrementAndGet();
                future.complete();
            })));
        }
        Awaitility.await().untilAtomic(count, Is.is((Object)options.getMaxFailures()));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
        Promise result = Promise.promise();
        this.breaker.executeAndReportWithFallback(result, future -> this.client.request(HttpMethod.GET, 8080, "localhost", "/long").compose(HttpClientRequest::send).onSuccess(response -> {
            System.out.println("Got response");
            future.complete();
        }), v -> "fallback");
        Awaitility.await().until(() -> ((String)result.future().result()).equals("fallback"));
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.OPEN);
    }

    @Test
    public void testUseRetryAfterHeaderValue() {
        this.breaker = CircuitBreaker.create((String)"test", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxRetries(1)).retryPolicy((failure, retryCount) -> {
            if (failure instanceof ServiceUnavailableException) {
                ServiceUnavailableException sue = (ServiceUnavailableException)((Object)((Object)failure));
                return TimeUnit.MILLISECONDS.convert(sue.delay, TimeUnit.SECONDS);
            }
            return 0L;
        });
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        List requestLocalDateTimes = Collections.synchronizedList(new ArrayList());
        Promise result = Promise.promise();
        this.breaker.executeAndReport(result, v -> {
            requestLocalDateTimes.add(LocalDateTime.now());
            this.client.request(HttpMethod.GET, 8080, "localhost", "/flaky").compose(req -> req.send().compose(resp -> {
                if (resp.statusCode() == 503) {
                    ServiceUnavailableException sue = new ServiceUnavailableException(Integer.parseInt(resp.getHeader(HttpHeaders.RETRY_AFTER)));
                    return Future.failedFuture((Throwable)((Object)sue));
                }
                return resp.body().map(Buffer::toString);
            })).onComplete((Handler)v);
        });
        Awaitility.await().until(() -> result.future().result() != null);
        Assertions.assertThat((Comparable)this.breaker.state()).isEqualTo((Object)CircuitBreakerState.CLOSED);
        Assert.assertEquals((long)2L, (long)requestLocalDateTimes.size());
        Assert.assertTrue((Duration.between((Temporal)requestLocalDateTimes.get(0), (Temporal)requestLocalDateTimes.get(1)).toMillis() >= 2000L ? 1 : 0) != 0);
    }

    private static class ServiceUnavailableException
    extends VertxException {
        final int delay;

        ServiceUnavailableException(int delay) {
            super("unavailable", true);
            this.delay = delay;
        }
    }
}

