/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Vertx;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DeprecatedRetryPolicyTest {
    private Vertx vertx;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void testWithRetryPolicy() {
        this.runRetryPolicyTest(retry -> (long)retry.intValue() * 100L);
    }

    @Test
    public void testWithZeroRetryPolicy() {
        this.runRetryPolicyTest(retry -> 0L);
    }

    @Test
    public void testWithNegativeRetryPolicy() {
        this.runRetryPolicyTest(retry -> -1L);
    }

    private void runRetryPolicyTest(Function<Integer, Long> retryPolicy) {
        CircuitBreaker breaker = CircuitBreaker.create((String)"my-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(5).setMaxRetries(5));
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger retryPolicyCounter = new AtomicInteger();
        breaker.retryPolicy(retry -> {
            retryPolicyCounter.incrementAndGet();
            return (Long)retryPolicy.apply((Integer)retry);
        });
        breaker.execute(future -> {
            counter.incrementAndGet();
            future.fail("FAILED");
        }).onComplete(ar -> {});
        Awaitility.await().untilAtomic(counter, Matchers.is((Object)6));
        Awaitility.await().untilAtomic(retryPolicyCounter, Matchers.is((Object)5));
    }
}

