/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.HystrixMetricHandler;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.parsetools.JsonParser;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HystrixMetricEventStreamTest {
    @Rule
    public RepeatRule rule = new RepeatRule();
    private CircuitBreaker breakerA;
    private CircuitBreaker breakerB;
    private CircuitBreaker breakerC;
    private Vertx vertx;
    private Random random = new Random();

    @Before
    public void setUp(TestContext tc) {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(tc.exceptionHandler());
    }

    @After
    public void tearDown() {
        this.vertx.exceptionHandler(null);
        if (this.breakerA != null) {
            this.breakerA.close();
        }
        if (this.breakerB != null) {
            this.breakerB.close();
        }
        if (this.breakerC != null) {
            this.breakerC.close();
        }
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    @Repeat(value=10)
    public void test() {
        CircuitBreakerOptions options = new CircuitBreakerOptions().setNotificationAddress("vertx.circuit-breaker").setTimeout(1000L);
        this.breakerA = CircuitBreaker.create((String)"A", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions(options));
        this.breakerB = CircuitBreaker.create((String)"B", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions(options));
        this.breakerC = CircuitBreaker.create((String)"C", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions(options));
        Router router = Router.router((Vertx)this.vertx);
        router.get("/metrics").handler((Handler)HystrixMetricHandler.create((Vertx)this.vertx));
        AtomicBoolean ready = new AtomicBoolean();
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, ar -> ready.set(ar.succeeded()));
        Awaitility.await().untilAtomic(ready, Is.is((Object)true));
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        HttpClient client = this.vertx.createHttpClient();
        JsonParser jp = JsonParser.newParser().objectValueMode().handler(jsonEvent -> responses.add(jsonEvent.objectValue()));
        RecordParser parser = RecordParser.newDelimited((String)"\n\n", buffer -> {
            String[] lines;
            String record = buffer.toString();
            for (String line : lines = record.split("\n")) {
                String l = line.trim();
                if (!l.startsWith("data:")) continue;
                String json = l.substring("data:".length());
                jp.handle((Object)Buffer.buffer((String)json));
            }
        });
        client.request(HttpMethod.GET, 8080, "localhost", "/metrics", ar1 -> {
            if (ar1.succeeded()) {
                HttpClientRequest req = (HttpClientRequest)ar1.result();
                req.send(ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientResponse resp = (HttpClientResponse)ar2.result();
                        resp.handler((Handler)parser);
                    }
                });
            }
        });
        for (int i = 0; i < 1000; ++i) {
            this.breakerA.execute(this.choose());
            this.breakerB.execute(this.choose());
            this.breakerC.execute(this.choose());
        }
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).until(() -> responses.size() > 50);
        JsonObject a = null;
        JsonObject b = null;
        JsonObject c = null;
        for (JsonObject json : responses) {
            switch (json.getString("name")) {
                case "A": {
                    a = json;
                    break;
                }
                case "B": {
                    b = json;
                    break;
                }
                case "C": {
                    c = json;
                }
            }
        }
        client.close();
        Assertions.assertThat(a).isNotNull();
        Assertions.assertThat(b).isNotNull();
        Assertions.assertThat(c).isNotNull();
    }

    private Handler<Promise<Void>> choose() {
        int choice = this.random.nextInt(5);
        switch (choice) {
            case 0: {
                return this.commandThatWorks();
            }
            case 1: {
                return this.commandThatFails();
            }
            case 2: {
                return this.commandThatCrashes();
            }
            case 3: {
                return this.commandThatTimeout(1000);
            }
            case 4: {
                return this.commandThatTimeoutAndFail(1000);
            }
        }
        return this.commandThatWorks();
    }

    private Handler<Promise<Void>> commandThatWorks() {
        return future -> this.vertx.setTimer(5L, l -> future.complete(null));
    }

    private Handler<Promise<Void>> commandThatFails() {
        return future -> this.vertx.setTimer(5L, l -> future.fail("expected failure"));
    }

    private Handler<Promise<Void>> commandThatCrashes() {
        return future -> {
            throw new RuntimeException("Expected error");
        };
    }

    private Handler<Promise<Void>> commandThatTimeout(int timeout) {
        return future -> this.vertx.setTimer((long)(timeout + 500), l -> future.complete(null));
    }

    private Handler<Promise<Void>> commandThatTimeoutAndFail(int timeout) {
        return future -> this.vertx.setTimer((long)(timeout + 500), l -> future.fail("late failure"));
    }
}

