/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Vertx;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NumberOfRetryTest {
    private Vertx vertx;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void testWithoutRetry() {
        CircuitBreaker breaker = CircuitBreaker.create((String)"my-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(5));
        AtomicInteger counter = new AtomicInteger();
        breaker.execute(future -> {
            counter.incrementAndGet();
            future.fail("FAILED");
        }).onComplete(ar -> {});
        Awaitility.await().untilAtomic(counter, Matchers.is((Object)1));
    }

    @Test
    public void testWithRetrySetToZero() {
        CircuitBreaker breaker = CircuitBreaker.create((String)"my-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(5).setMaxRetries(0));
        AtomicInteger counter = new AtomicInteger();
        breaker.execute(future -> {
            counter.incrementAndGet();
            future.fail("FAILED");
        }).onComplete(ar -> {});
        Awaitility.await().untilAtomic(counter, Matchers.is((Object)1));
    }

    @Test
    public void testWithRetrySetToOne() {
        CircuitBreaker breaker = CircuitBreaker.create((String)"my-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(5).setMaxRetries(1));
        AtomicInteger counter = new AtomicInteger();
        breaker.execute(future -> {
            counter.incrementAndGet();
            future.fail("FAILED");
        }).onComplete(ar -> {});
        Awaitility.await().untilAtomic(counter, Matchers.is((Object)2));
    }

    @Test
    public void testWithRetrySetToFive() {
        CircuitBreaker breaker = CircuitBreaker.create((String)"my-circuit-breaker", (Vertx)this.vertx, (CircuitBreakerOptions)new CircuitBreakerOptions().setMaxFailures(5).setMaxRetries(5));
        AtomicInteger counter = new AtomicInteger();
        breaker.execute(future -> {
            counter.incrementAndGet();
            future.fail("FAILED");
        }).onComplete(ar -> {});
        Awaitility.await().untilAtomic(counter, Matchers.is((Object)6));
    }
}

