/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.metrics;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class RandomClient
extends AbstractVerticle {
    List<String> paths = new ArrayList<String>();
    Random random = new Random();

    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle(RandomClient.class.getName(), new DeploymentOptions().setInstances(4));
    }

    public void start() throws Exception {
        this.paths.add("/A");
        this.paths.add("/A");
        this.paths.add("/B");
        this.paths.add("/C");
        AtomicInteger counter = new AtomicInteger();
        this.vertx.setPeriodic(500L, l -> {
            int index = this.random.nextInt(this.paths.size());
            int count = counter.getAndIncrement();
            this.vertx.createHttpClient().request(HttpMethod.GET, 8080, "localhost", this.paths.get(index), ar1 -> {
                if (ar1.succeeded()) {
                    HttpClientRequest request = (HttpClientRequest)ar1.result();
                    request.send(ar2 -> {
                        if (ar2.succeeded()) {
                            HttpClientResponse response = (HttpClientResponse)ar2.result();
                            System.out.println((Object)((Object)this) + "[" + count + "] (" + this.paths.get(index) + ") Response: " + response.statusMessage());
                            response.bodyHandler(buffer -> System.out.println((Object)((Object)this) + "[" + count + "] (" + this.paths.get(index) + ") Data: " + buffer.toString()));
                        }
                    });
                }
            });
        });
    }
}

