/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.git;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.config.git.GitConfigStoreFactory;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class GitConfigStoreTest {
    private Vertx vertx;
    private ConfigRetriever retriever;
    private Git git;
    private Git bare;
    private File bareRoot;
    private File root = new File("target/junk/repo");
    private String branch;
    private String remote = "origin";

    @Before
    public void setUp(TestContext context) throws IOException, GitAPIException {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(context.exceptionHandler());
        FileUtils.deleteDirectory((File)new File("target/junk"));
        this.bareRoot = new File("target/junk/bare-repo.git");
        this.bare = this.createBareRepository(this.bareRoot);
        this.git = this.connect(this.bareRoot, this.root);
        this.branch = "master";
    }

    @After
    public void tearDown() {
        AtomicBoolean done = new AtomicBoolean();
        if (this.retriever != null) {
            this.retriever.close();
        }
        if (this.git != null) {
            this.git.close();
        }
        if (this.bare != null) {
            this.bare.close();
        }
        this.vertx.close(v -> done.set(true));
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
    }

    @Test
    public void testWithEmptyRepository(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/some-text.txt"), null);
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "**/*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isEmpty();
            async.complete();
        });
    }

    @Test
    public void testWithARepositoryWithAMatchingFile(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/some-text.txt"), null);
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), null);
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("key")).isEqualTo((Object)"value");
            Assertions.assertThat((Boolean)json.getBoolean("true")).isTrue();
            Assertions.assertThat((Boolean)json.getBoolean("false")).isFalse();
            Assertions.assertThat((String)json.getString("missing")).isNull();
            Assertions.assertThat((Integer)json.getInteger("int")).isEqualTo(5);
            Assertions.assertThat((Double)json.getDouble("float")).isEqualTo(25.3);
            Assertions.assertThat((int)json.getJsonArray("array").size()).isEqualTo(3);
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)1)).isTrue();
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)2)).isTrue();
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)3)).isTrue();
            Assertions.assertThat((String)json.getJsonObject("sub").getString("foo")).isEqualTo((Object)"bar");
            async.complete();
        });
    }

    @Test
    public void testWithACustomBranch(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), null);
        this.branch = "dev";
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), null);
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("branch", this.branch).put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("key")).isEqualTo((Object)"value");
            async.complete();
        });
    }

    @Test
    public void testWithACustomBranchAndRemote(TestContext tc) throws GitAPIException, IOException {
        this.git.close();
        this.remote = "acme";
        FileUtils.deleteQuietly((File)this.root);
        this.git = this.connect(this.bareRoot, this.root);
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), null);
        this.branch = "dev";
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), null);
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("branch", this.branch).put("remote", this.remote).put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("key")).isEqualTo((Object)"value");
            async.complete();
        });
    }

    @Test
    public void testWithARepositoryWithAMatchingPropertiesFile(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/some-text.txt"), null);
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), null);
        this.add(this.git, this.root, new File("src/test/resources/files/regular.properties"), null);
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.properties").put("format", "properties"))))));
        this.retriever.getConfig(ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("key")).isEqualTo((Object)"value");
            Assertions.assertThat((Boolean)json.getBoolean("true")).isTrue();
            Assertions.assertThat((Boolean)json.getBoolean("false")).isFalse();
            Assertions.assertThat((String)json.getString("missing")).isNull();
            Assertions.assertThat((Integer)json.getInteger("int")).isEqualTo(5);
            Assertions.assertThat((Double)json.getDouble("float")).isEqualTo(25.3);
            async.complete();
        });
    }

    @Test(expected=NullPointerException.class)
    public void testWithMissingPathInConf() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("no-path", "").put("url", "git url").put("filesets", new JsonArray()));
    }

    @Test(expected=NullPointerException.class)
    public void testWithMissingGitRepoUrlInConf() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("path", "target").put("filesets", new JsonArray()));
    }

    @Test(expected=NullPointerException.class)
    public void testWithMissingFileSets() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("path", "src/test/resources").put("url", "git url"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithMissingPatternInAFileSet() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("path", "src/test/resources").put("filesets", new JsonArray().add(new JsonObject().put("format", "properties"))));
    }

    @Test
    public void testName() {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)new GitConfigStoreFactory().name()).isNotNull()).isEqualTo((Object)"git");
    }

    @Test
    public void testWithNonExistingPath(TestContext tc) throws IOException, GitAPIException {
        this.add(this.git, this.root, new File("src/test/resources/files/some-text.txt"), null);
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), null);
        this.push(this.git);
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/do-not-exist").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            async.complete();
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithAPathThatIsAFile() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("path", "src/test/resources/files/regular.json").put("url", this.bareRoot.getAbsolutePath()).put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWhenTheFormatIsUnknown() {
        new GitConfigStoreFactory().create(this.vertx, new JsonObject().put("path", "src/test/resources/files/regular.json").put("url", this.bareRoot.getAbsolutePath()).put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json").put("format", "unknown"))));
    }

    @Test
    public void testWithoutAnExistingRepo(TestContext tc) throws IOException, GitAPIException {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/do-not-exist").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            Assertions.assertThat((String)ar.cause().getMessage()).contains(new CharSequence[]{"origin", "master"});
            async.complete();
        });
    }

    @Test
    public void testWith2FileSetsAndNoIntersection(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/regular.json"), "file");
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "file/reg*.json")).add(new JsonObject().put("pattern", "dir/a.*son"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("key")).isEqualTo((Object)"value");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            async.complete();
        });
    }

    @Test
    public void testWith2FileSetsAndWithIntersection(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/b.json"), "dir");
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/b.json")).add(new JsonObject().put("pattern", "dir/a.*son"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("b.name")).isEqualTo((Object)"B");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("conflict")).isEqualTo((Object)"A");
            async.complete();
        });
    }

    @Test
    public void testWith2FileSetsAndWithIntersectionReversed(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/b.json"), "dir");
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/a.*son")).add(new JsonObject().put("pattern", "dir/b.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("conflict")).isEqualTo((Object)"B");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("b.name")).isEqualTo((Object)"B");
            async.complete();
        });
    }

    @Test
    public void testWithAFileSetMatching2FilesWithConflict(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/b.json"), "dir");
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/?.*son"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("b.name")).isEqualTo((Object)"B");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("conflict")).isEqualTo((Object)"B");
            async.complete();
        });
    }

    @Test
    public void testWithAFileSetMatching2FilesOneNotBeingAJsonFile(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.add(this.git, this.root, new File("src/test/resources/files/a-bad.json"), "dir");
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/a?*.*son"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.failed());
            Assertions.assertThat((Throwable)ar.cause()).isInstanceOf(DecodeException.class);
            async.complete();
        });
    }

    @Test
    public void testConfigurationUpdate() throws IOException, GitAPIException {
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().setScanPeriod(1000L).addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/*.json"))))));
        AtomicBoolean done = new AtomicBoolean();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        this.updateA();
        Awaitility.await().until(() -> "A2".equals(this.retriever.getCachedConfig().getString("a.name")) && "B".equalsIgnoreCase(this.retriever.getCachedConfig().getString("b.name")));
    }

    @Test
    public void testConfigurationUpdateWithMergeIssue_Commit(TestContext tc) throws IOException, GitAPIException {
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().setScanPeriod(1000L).addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/*.json"))))));
        AtomicBoolean done = new AtomicBoolean();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        File a = new File("target/junk/work/dir/a.json");
        Assertions.assertThat((File)a).isFile();
        FileUtils.write((File)a, (CharSequence)new JsonObject().put("a.name", "A").put("conflict", "A").put("added", "added").encodePrettily(), (Charset)StandardCharsets.UTF_8);
        this.git.add().addFilepattern("dir/a.json").call();
        this.git.commit().setMessage("update A").setAuthor("clement", "clement@apache.org").setCommitter("clement", "clement@apache.org").call();
        done.set(false);
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("added")).isEqualTo((Object)"added");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        this.updateA();
        Async async = tc.async();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isFalse();
            Assertions.assertThat((String)ar.cause().getMessage()).containsIgnoringCase((CharSequence)"conflict");
            async.complete();
        });
    }

    @Test
    public void testConfigurationUpdateWithMergeIssue_Edit(TestContext tc) throws IOException, GitAPIException {
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().setScanPeriod(1000L).addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/*.json"))))));
        AtomicBoolean done = new AtomicBoolean();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        File a = new File("target/junk/work/dir/a.json");
        Assertions.assertThat((File)a).isFile();
        FileUtils.write((File)a, (CharSequence)new JsonObject().put("a.name", "A-modified").put("conflict", "A").encodePrettily(), (Charset)StandardCharsets.UTF_8);
        done.set(false);
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A-modified");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        this.updateA();
        Async async = tc.async();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isFalse();
            Assertions.assertThat((String)ar.cause().getMessage()).containsIgnoringCase((CharSequence)"conflict");
            async.complete();
        });
    }

    @Test
    public void testUsingAnExistingRepo() throws IOException, GitAPIException {
        this.git.close();
        this.root = new File("target/junk/work");
        this.git = this.connect(this.bareRoot, this.root);
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().setScanPeriod(1000L).addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/*.json"))))));
        AtomicBoolean done = new AtomicBoolean();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        this.updateA();
        Awaitility.await().until(() -> "A2".equals(this.retriever.getCachedConfig().getString("a.name")) && "B".equalsIgnoreCase(this.retriever.getCachedConfig().getString("b.name")));
    }

    @Test
    public void testWithExistingRepoOnTheWrongBranch() throws Exception {
        this.git.close();
        this.root = new File("target/junk/work");
        this.git = this.connect(this.bareRoot, this.root);
        this.add(this.git, this.root, new File("src/test/resources/files/a.json"), "dir");
        this.push(this.git);
        this.branch = "dev";
        this.add(this.git, this.root, new File("src/test/resources/files/b.json"), "dir");
        this.push(this.git);
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().setScanPeriod(1000L).addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", this.bareRoot.getAbsolutePath()).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "dir/*.json"))))));
        AtomicBoolean done = new AtomicBoolean();
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((String)((JsonObject)ar.result()).getString("a.name")).isEqualTo((Object)"A");
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
        this.updateA();
        Awaitility.await().until(() -> "A2".equals(this.retriever.getCachedConfig().getString("a.name")) && "B".equalsIgnoreCase(this.retriever.getCachedConfig().getString("b.name")));
    }

    private void updateA() {
        try {
            this.add(this.git, this.root, new File("src/test/resources/files/b.json"), "dir");
            FileUtils.copyFile((File)new File("src/test/resources/files/a-v2.json"), (File)new File(this.root, "dir/a.json"));
            this.git.add().addFilepattern("dir/a.json").call();
            this.git.commit().setAuthor("clement", "clement@apache.org").setCommitter("clement", "clement@apache.org").setMessage("Update a.json").call();
            this.push(this.git);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void push(Git git) throws GitAPIException {
        git.push().setRemote(this.remote).setForce(true).call();
    }

    private Git connect(File bareRoot, File root) throws MalformedURLException, GitAPIException {
        return Git.cloneRepository().setURI(bareRoot.getAbsolutePath()).setRemote(this.remote).setDirectory(root).call();
    }

    private Git createBareRepository(File root) throws GitAPIException {
        return Git.init().setDirectory(root).setBare(true).call();
    }

    private GitConfigStoreTest add(Git git, File root, File file, String directory) throws IOException, GitAPIException {
        String relative;
        File output;
        if (!file.isFile()) {
            throw new RuntimeException("File not found " + file.getAbsolutePath());
        }
        if (!"master".equalsIgnoreCase(git.getRepository().getBranch())) {
            git.checkout().setCreateBranch(true).setName("master").call();
        }
        if (!this.branch.equalsIgnoreCase(git.getRepository().getBranch())) {
            boolean create = true;
            for (Ref ref : git.branchList().call()) {
                if (!ref.getName().equals("refs/heads/" + this.branch)) continue;
                create = false;
            }
            git.checkout().setCreateBranch(create).setName(this.branch).call();
        }
        if ((output = new File(root, relative = directory != null ? directory + File.separator + file.getName() : file.getName())).exists()) {
            output.delete();
        }
        if (!output.getParentFile().isDirectory()) {
            output.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)file, (File)output);
        git.add().addFilepattern(relative).call();
        git.commit().setAuthor("clement", "clement@apache.org").setCommitter("clement", "clement@apache.org").setMessage("Add " + relative).call();
        return this;
    }
}

