/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.git;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class GitConfigStoreWithGithubTest {
    private static final String REPO = "https://github.com/cescoffier/vertx-config-test.git";
    private Vertx vertx;
    private ConfigRetriever retriever;
    private Git git;
    private File root = new File("target/junk/repo");
    private String branch;
    private String remote = "origin";

    @Before
    public void setUp(TestContext context) throws IOException, GitAPIException {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(context.exceptionHandler());
        FileUtils.deleteDirectory((File)new File("target/junk"));
        this.git = this.connect(this.root);
    }

    @After
    public void tearDown() {
        AtomicBoolean done = new AtomicBoolean();
        if (this.retriever != null) {
            this.retriever.close();
        }
        if (this.git != null) {
            this.git.close();
        }
        this.vertx.close(v -> done.set(true));
        Awaitility.await().untilAtomic(done, CoreMatchers.is((Object)true));
    }

    @Test
    public void testOnMasterWithASingleFile(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", REPO).put("path", "target/junk/work").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "a.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("branch")).isEqualToIgnoringCase((CharSequence)"master");
            Assertions.assertThat((String)json.getString("name")).isEqualToIgnoringCase((CharSequence)"A");
            async.complete();
        });
    }

    @Test
    public void testOnDevWithATwoFiles(TestContext tc) throws GitAPIException, IOException {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("git").setConfig(new JsonObject().put("url", REPO).put("path", "target/junk/work").put("branch", "dev").put("filesets", new JsonArray().add(new JsonObject().put("pattern", "*.json"))))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotEmpty();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json).isNotNull();
            Assertions.assertThat((String)json.getString("branch")).isEqualToIgnoringCase((CharSequence)"dev");
            Assertions.assertThat((String)json.getString("key")).isEqualToIgnoringCase((CharSequence)"value");
            Assertions.assertThat((String)json.getString("keyB")).isEqualToIgnoringCase((CharSequence)"valueB");
            Assertions.assertThat((String)json.getString("name")).isEqualToIgnoringCase((CharSequence)"B");
            async.complete();
        });
    }

    private Git connect(File root) throws MalformedURLException, GitAPIException {
        return Git.cloneRepository().setURI(REPO).setRemote(this.remote).setDirectory(root).call();
    }
}

