/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.format.SnakeCase;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.config.vault.client.AuthConverter;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false, jsonPropertyNameFormatter=SnakeCase.class)
public class Auth {
    private String accessor;
    private long leaseDuration;
    private boolean renewable;
    private JsonObject metadata;
    private String clientToken;
    private List<String> policies;

    public Auth() {
    }

    public Auth(JsonObject json) {
        AuthConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getAccessor() {
        return this.accessor;
    }

    public Auth setAccessor(String accessor) {
        this.accessor = accessor;
        return this;
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public Auth setLeaseDuration(long leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public Auth setRenewable(boolean renewable) {
        this.renewable = renewable;
        return this;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public Auth setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Auth setClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public Auth setPolicies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    public String getApplicationId() {
        return this.getMetadata() != null ? this.getMetadata().getString("app-id") : null;
    }

    public String getUserId() {
        return this.getMetadata() != null ? this.getMetadata().getString("user-id") : null;
    }

    public String getUsername() {
        return this.getMetadata() != null ? this.getMetadata().getString("username") : null;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AuthConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

