/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.vault.client;

import io.vertx.config.vault.client.Auth;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class AuthConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, Auth obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "accessor": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAccessor((String)member.getValue());
                    break;
                }
                case "application_id": {
                    break;
                }
                case "client_token": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientToken((String)member.getValue());
                    break;
                }
                case "lease_duration": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLeaseDuration(((Number)member.getValue()).longValue());
                    break;
                }
                case "metadata": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setMetadata(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "policies": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setPolicies(list);
                    break;
                }
                case "renewable": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRenewable((Boolean)member.getValue());
                    break;
                }
                case "user_id": {
                    break;
                }
            }
        }
    }

    static void toJson(Auth obj, JsonObject json) {
        AuthConverter.toJson(obj, json.getMap());
    }

    static void toJson(Auth obj, Map<String, Object> json) {
        if (obj.getAccessor() != null) {
            json.put("accessor", obj.getAccessor());
        }
        if (obj.getApplicationId() != null) {
            json.put("application_id", obj.getApplicationId());
        }
        if (obj.getClientToken() != null) {
            json.put("client_token", obj.getClientToken());
        }
        json.put("lease_duration", obj.getLeaseDuration());
        if (obj.getMetadata() != null) {
            json.put("metadata", obj.getMetadata());
        }
        if (obj.getPolicies() != null) {
            JsonArray array = new JsonArray();
            obj.getPolicies().forEach(item -> array.add(item));
            json.put("policies", array);
        }
        json.put("renewable", obj.isRenewable());
        if (obj.getUserId() != null) {
            json.put("user_id", obj.getUserId());
        }
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
    }
}

