/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.yaml;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class YamlProcessorTest {
    private ConfigRetriever retriever;
    private Vertx vertx;

    @Before
    public void setUp(TestContext tc) {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(tc.exceptionHandler());
    }

    @After
    public void tearDown() {
        this.retriever.close();
        this.vertx.close();
    }

    @Test
    public void testEmptyYaml(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/empty.yaml"))));
        this.retriever.getConfig(ar -> {
            this.expectSuccess((AsyncResult)ar);
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isNotNull();
            Assertions.assertThat((Iterable)((Iterable)ar.result())).isEmpty();
            async.complete();
        });
    }

    private void expectSuccess(AsyncResult ar) {
        if (ar.failed()) {
            ar.cause().printStackTrace();
            Assert.fail((String)("Failure unexpected: " + ar.cause().getMessage()));
        }
        Assertions.assertThat((boolean)ar.succeeded()).isTrue();
    }

    @Test
    public void testWithTextFile(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/some-text.txt"))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).isInstanceOf(DecodeException.class);
            async.complete();
        });
    }

    @Test
    public void testWithMissingFile(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/some-missing-file.yaml"))));
        this.retriever.getConfig(ar -> {
            Assertions.assertThat((boolean)ar.failed()).isTrue();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ar.cause()).isNotNull()).isInstanceOf(FileSystemException.class);
            async.complete();
        });
    }

    @Test
    public void testBasicYamlFile(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/basic.yaml"))));
        this.retriever.getConfig(ar -> {
            this.expectSuccess((AsyncResult)ar);
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Integer)json.getInteger("invoice")).isEqualTo(34843);
            Assertions.assertThat((String)json.getString("date")).isEqualTo((Object)"2001-01-23");
            JsonObject bill = json.getJsonObject("bill-to");
            Assertions.assertThat((Iterable)bill).contains((Object[])new Map.Entry[]{Assertions.entry((Object)"given", (Object)"Chris"), Assertions.entry((Object)"family", (Object)"Dumars")});
            ((IterableAssert)Assertions.assertThat((Iterable)bill.getJsonObject("address")).isNotNull()).isNotEmpty();
            JsonArray products = json.getJsonArray("product");
            Assertions.assertThat((Iterable)products).hasSize(2);
            Assertions.assertThat((Float)products.getJsonObject(0).getFloat("price")).isEqualTo(450.0f);
            Assertions.assertThat((Double)products.getJsonObject(1).getDouble("price")).isEqualTo(2392.0);
            Assertions.assertThat((String)json.getString("comments")).contains(new CharSequence[]{"Late afternoon is best. Backup contact is Nancy Billsmer @"});
            async.complete();
        });
    }

    @Test
    public void testSimpleYamlConfiguration(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/simple.yaml"))));
        this.retriever.getConfig(ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            Assertions.assertThat((boolean)ar.succeeded()).isTrue();
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((String)json.getString("key")).isEqualTo((Object)"value");
            Assertions.assertThat((Boolean)json.getBoolean("true")).isTrue();
            Assertions.assertThat((Boolean)json.getBoolean("false")).isFalse();
            Assertions.assertThat((String)json.getString("missing")).isNull();
            Assertions.assertThat((Integer)json.getInteger("int")).isEqualTo(5);
            Assertions.assertThat((Double)json.getDouble("float")).isEqualTo(25.3);
            Assertions.assertThat((int)json.getJsonArray("array").size()).isEqualTo(3);
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)1)).isTrue();
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)2)).isTrue();
            Assertions.assertThat((boolean)json.getJsonArray("array").contains((Object)3)).isTrue();
            Assertions.assertThat((String)json.getJsonObject("sub").getString("foo")).isEqualTo((Object)"bar");
            async.complete();
        });
    }

    @Test
    public void testStructures(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", "src/test/resources/structure.yaml"))));
        this.retriever.getConfig(ar -> {
            this.expectSuccess((AsyncResult)ar);
            JsonObject json = (JsonObject)ar.result();
            Assertions.assertThat((Iterable)json.getJsonArray("movies")).containsExactly(new Object[]{"Casablanca", "V for Vendetta"});
            Assertions.assertThat((Iterable)json.getJsonArray("shopping")).containsExactly(new Object[]{"milk", "pumpkin pie", "eggs", "juice"});
            Assertions.assertThat((Iterable)json.getJsonObject("blockA")).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)"name", (Object)"John Smith"), Assertions.entry((Object)"age", (Object)33)});
            Assertions.assertThat((Iterable)json.getJsonObject("blockB")).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)"name", (Object)"John Smith"), Assertions.entry((Object)"age", (Object)33)});
            Assertions.assertThat((String)json.getString("newLines-preserved")).contains(new CharSequence[]{"\n", "\""});
            Assertions.assertThat((String)json.getString("newLines-folded")).contains(new CharSequence[]{"Wrapped text will be folded into a single paragraph"}).contains(new CharSequence[]{"\nBlank lines denote"});
            Assertions.assertThat((byte[])json.getBinary("picture")).isNotEmpty();
            async.complete();
        });
    }
}

