/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.yaml;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class YamlMultipleVerticlesTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void testReadYamlConcurrent(TestContext testContext) {
        int instances = 4;
        this.vertx.deployVerticle(() -> new ConfigYamlVerticle(), new DeploymentOptions().setInstances(instances)).onComplete(testContext.asyncAssertSuccess(va -> this.vertx.undeploy(va, testContext.asyncAssertSuccess())));
    }

    private static class ConfigYamlVerticle
    extends AbstractVerticle {
        private ConfigRetriever retriever;

        private ConfigYamlVerticle() {
        }

        public void start(Promise<Void> startPromise) throws Exception {
            ConfigStoreOptions store = new ConfigStoreOptions().setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", (Object)"src/test/resources/simple.yaml"));
            this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(store));
            this.retriever.getConfig().onComplete(js -> {
                if (js.succeeded()) {
                    String value = ((JsonObject)js.result()).getString("key");
                    Assert.assertEquals((Object)"value", (Object)value);
                    startPromise.complete();
                } else {
                    startPromise.fail(js.cause());
                }
            });
        }

        public void stop() throws Exception {
            this.retriever.close();
        }
    }
}

