/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import java.util.function.Function;

class RegistryHelper {
    private static final Function<Metric, ThroughputMeter> THROUGHPUT_METER = metric -> {
        if (metric != null) {
            return (ThroughputMeter)((Object)metric);
        }
        return new ThroughputMeter();
    };
    private static final Function<Metric, ThroughputTimer> THROUGHPUT_TIMER = metric -> {
        if (metric != null) {
            return (ThroughputTimer)((Object)metric);
        }
        return new ThroughputTimer();
    };

    RegistryHelper() {
    }

    public static void shutdown(MetricRegistry registry) {
        registry.removeMatching((name, metric) -> true);
    }

    public static ThroughputMeter throughputMeter(MetricRegistry registry, String name) {
        return RegistryHelper.getOrAdd(registry, name, THROUGHPUT_METER);
    }

    public static ThroughputTimer throughputTimer(MetricRegistry registry, String name) {
        return RegistryHelper.getOrAdd(registry, name, THROUGHPUT_TIMER);
    }

    public static <M extends Metric> M getOrAdd(MetricRegistry registry, String name, Function<Metric, M> metricProvider) {
        block4: {
            Metric found;
            Metric metric = (Metric)registry.getMetrics().get(name);
            Metric metric2 = found = metric != null ? (Metric)metricProvider.apply(metric) : null;
            if (found != null) {
                return (M)found;
            }
            if (metric == null) {
                try {
                    return (M)registry.register(name, (Metric)metricProvider.apply(null));
                }
                catch (IllegalArgumentException e) {
                    metric = (Metric)registry.getMetrics().get(name);
                    found = (Metric)metricProvider.apply(metric);
                    if (found == null) break block4;
                    return (M)found;
                }
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }
}

