/*
 * Copyright (c) 2011-2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */
package io.vertx.httpproxy.interceptors;

import io.vertx.codegen.annotations.Unstable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.interceptors.impl.HeadInterceptorBuilderImpl;

/**
 * An interceptor updating HTTP request/response head attributes (headers, path, query params).
 */
@VertxGen
@Unstable
public interface HeadInterceptor extends ProxyInterceptor {

  /**
   * @return a builder for head interception
   */
  static HeadInterceptorBuilder builder() {
    return new HeadInterceptorBuilderImpl();
  }
}
