/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public class DataConverter {
    public static byte[] toCachedObject(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (o instanceof Serializable) {
            baos.write(0);
            DataConverter.writeSerializable(baos, (Serializable)o);
        } else if (o instanceof ClusterSerializable) {
            baos.write(1);
            DataConverter.writeClusterSerializable(baos, (ClusterSerializable)o);
        } else {
            throw new IllegalArgumentException("Cannot convert object of type: " + o.getClass());
        }
        return baos.toByteArray();
    }

    private static void writeSerializable(ByteArrayOutputStream baos, Serializable o) {
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeClusterSerializable(ByteArrayOutputStream baos, ClusterSerializable o) {
        Buffer buffer = Buffer.buffer();
        byte[] classNameBytes = o.getClass().getName().getBytes(StandardCharsets.UTF_8);
        buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
        o.writeToBuffer(buffer);
        baos.write(buffer.getBytes(), 0, buffer.length());
    }

    public static <T> T fromCachedObject(byte[] value) {
        if (value == null) {
            return null;
        }
        byte type = value[0];
        if (type == 0) {
            return (T)DataConverter.readSerializable(value);
        }
        if (type == 1) {
            return (T)DataConverter.readClusterSerializable(value);
        }
        throw new IllegalArgumentException("Cannot convert object of type: " + type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object readSerializable(byte[] value) {
        ByteArrayInputStream bais = new ByteArrayInputStream(value, 1, value.length - 1);
        try (ObjectInputStream in = new ObjectInputStream(bais);){
            Object object = in.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClusterSerializable readClusterSerializable(byte[] value) {
        ClusterSerializable clusterSerializable;
        Buffer buffer = Buffer.buffer((byte[])value);
        int pos = 1;
        int len = buffer.getInt(pos);
        byte[] classNameBytes = buffer.getBytes(pos += 4, pos + len);
        pos += len;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(new String(classNameBytes, StandardCharsets.UTF_8));
            clusterSerializable = (ClusterSerializable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        clusterSerializable.readFromBuffer(pos, buffer);
        return clusterSerializable;
    }

    private DataConverter() {
    }
}

