/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.cluster.infinispan.InfinispanAsyncMap;
import io.vertx.ext.cluster.infinispan.impl.CloseableIteratorCollectionStream;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableSupplier;

public class InfinispanAsyncMapImpl<K, V>
implements AsyncMap<K, V>,
InfinispanAsyncMap<K, V> {
    private final VertxInternal vertx;
    private final AdvancedCache<byte[], byte[]> cache;
    private final AdvancedCache<byte[], byte[]> ignoreReturnCache;

    public InfinispanAsyncMapImpl(VertxInternal vertx, Cache<byte[], byte[]> cache) {
        this.vertx = vertx;
        this.cache = cache.getAdvancedCache();
        this.ignoreReturnCache = this.cache.withFlags(Flag.IGNORE_RETURN_VALUES);
    }

    public Future<V> get(K k) {
        byte[] kk = DataConverter.toCachedObject(k);
        return Future.fromCompletionStage((CompletionStage)this.cache.getAsync((Object)kk), (Context)this.vertx.getOrCreateContext()).map(DataConverter::fromCachedObject);
    }

    public Future<Void> put(K k, V v) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        return Future.fromCompletionStage((CompletionStage)this.ignoreReturnCache.putAsync((Object)kk, (Object)vv), (Context)this.vertx.getOrCreateContext()).mapEmpty();
    }

    public Future<Void> put(K k, V v, long ttl) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        CompletableFuture completionStage = this.ignoreReturnCache.putAsync((Object)kk, (Object)vv, ttl, TimeUnit.MILLISECONDS);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)this.vertx.getOrCreateContext()).mapEmpty();
    }

    public Future<V> putIfAbsent(K k, V v) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        return Future.fromCompletionStage((CompletionStage)this.cache.putIfAbsentAsync((Object)kk, (Object)vv), (Context)this.vertx.getOrCreateContext()).map(DataConverter::fromCachedObject);
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        CompletableFuture completionStage = this.cache.putIfAbsentAsync((Object)kk, (Object)vv, ttl, TimeUnit.MILLISECONDS);
        return Future.fromCompletionStage((CompletionStage)completionStage, (Context)this.vertx.getOrCreateContext()).map(DataConverter::fromCachedObject);
    }

    public Future<V> remove(K k) {
        byte[] kk = DataConverter.toCachedObject(k);
        return Future.fromCompletionStage((CompletionStage)this.cache.removeAsync((Object)kk), (Context)this.vertx.getOrCreateContext()).map(DataConverter::fromCachedObject);
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        return Future.fromCompletionStage((CompletionStage)this.cache.removeAsync((Object)kk, (Object)vv), (Context)this.vertx.getOrCreateContext());
    }

    public Future<V> replace(K k, V v) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] vv = DataConverter.toCachedObject(v);
        return Future.fromCompletionStage((CompletionStage)this.cache.replaceAsync((Object)kk, (Object)vv), (Context)this.vertx.getOrCreateContext()).map(DataConverter::fromCachedObject);
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        byte[] kk = DataConverter.toCachedObject(k);
        byte[] oo = DataConverter.toCachedObject(oldValue);
        byte[] nn = DataConverter.toCachedObject(newValue);
        return Future.fromCompletionStage((CompletionStage)this.cache.replaceAsync((Object)kk, (Object)oo, (Object)nn), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Void> clear() {
        return Future.fromCompletionStage((CompletionStage)this.cache.clearAsync(), (Context)this.vertx.getOrCreateContext());
    }

    public Future<Integer> size() {
        return this.vertx.executeBlocking(future -> future.complete((Object)this.cache.size()), false);
    }

    public Future<Set<K>> keys() {
        return this.vertx.executeBlocking(promise -> {
            Set cacheKeys = (Set)this.cache.keySet().stream().collect(CacheCollectors.serializableCollector(Collectors::toSet));
            promise.complete(cacheKeys.stream().map(DataConverter::fromCachedObject).collect(Collectors.toSet()));
        }, false);
    }

    public Future<List<V>> values() {
        return this.vertx.executeBlocking(promise -> {
            List cacheValues = (List)this.cache.values().stream().collect(CacheCollectors.serializableCollector(Collectors::toList));
            promise.complete(cacheValues.stream().map(DataConverter::fromCachedObject).collect(Collectors.toList()));
        }, false);
    }

    public Future<Map<K, V>> entries() {
        return this.vertx.executeBlocking(promise -> {
            Map cacheEntries = (Map)this.cache.entrySet().stream().collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            HashMap result = new HashMap();
            for (Map.Entry entry : cacheEntries.entrySet()) {
                Object k = DataConverter.fromCachedObject((byte[])entry.getKey());
                Object v = DataConverter.fromCachedObject((byte[])entry.getValue());
                result.put(k, v);
            }
            promise.complete(result);
        }, false);
    }

    @Override
    public ReadStream<K> keyStream() {
        return new CloseableIteratorCollectionStream<byte[], Object>((Context)this.vertx.getOrCreateContext(), () -> this.cache.keySet(), DataConverter::fromCachedObject);
    }

    @Override
    public ReadStream<V> valueStream() {
        return new CloseableIteratorCollectionStream<byte[], Object>((Context)this.vertx.getOrCreateContext(), () -> this.cache.values(), DataConverter::fromCachedObject);
    }

    @Override
    public ReadStream<Map.Entry<K, V>> entryStream() {
        return new CloseableIteratorCollectionStream<Map.Entry, Map.Entry>((Context)this.vertx.getOrCreateContext(), () -> this.cache.entrySet(), cacheEntry -> {
            Object key = DataConverter.fromCachedObject((byte[])cacheEntry.getKey());
            Object value = DataConverter.fromCachedObject((byte[])cacheEntry.getValue());
            return new AbstractMap.SimpleImmutableEntry(key, value);
        });
    }
}

