/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import java.util.Objects;
import org.infinispan.counter.api.SyncStrongCounter;

public class InfinispanCounter
implements Counter {
    private final Vertx vertx;
    private final SyncStrongCounter strongCounter;

    public InfinispanCounter(Vertx vertx, SyncStrongCounter strongCounter) {
        this.vertx = vertx;
        this.strongCounter = strongCounter;
    }

    public Future<Long> get() {
        return this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.getValue()), false);
    }

    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.get().onComplete(resultHandler);
    }

    public Future<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(1L, resultHandler);
    }

    public Future<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAndAdd(1L, resultHandler);
    }

    public Future<Long> decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(-1L, resultHandler);
    }

    public Future<Long> addAndGet(long value) {
        return this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.addAndGet(value)), false);
    }

    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.addAndGet(value).onComplete(resultHandler);
    }

    public Future<Long> getAndAdd(long value) {
        return this.vertx.executeBlocking(future -> future.complete((Object)(this.strongCounter.addAndGet(value) - value)), false);
    }

    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAndAdd(value).onComplete(resultHandler);
    }

    public Future<Boolean> compareAndSet(long expected, long value) {
        return this.vertx.executeBlocking(future -> future.complete((Object)this.strongCounter.compareAndSet(expected, value)), false);
    }

    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.compareAndSet(expected, value).onComplete(resultHandler);
    }
}

