/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.util.function.SerializablePredicate;

public class SubsCacheHelper {
    private static final Logger log = LoggerFactory.getLogger(SubsCacheHelper.class);
    private final EmbeddedMultimapCache<String, byte[]> subsCache;
    private final NodeSelector nodeSelector;
    private final EntryListener entryListener;

    public SubsCacheHelper(DefaultCacheManager cacheManager, NodeSelector nodeSelector) {
        MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cacheManager);
        this.subsCache = (EmbeddedMultimapCache)multimapCacheManager.get("__vertx.subs");
        this.nodeSelector = nodeSelector;
        this.entryListener = new EntryListener();
        Set filterAnnotations = Stream.builder().add(CacheEntryCreated.class).add(CacheEntryModified.class).add(CacheEntryRemoved.class).build().collect(Collectors.toSet());
        this.subsCache.getCache().addFilteredListener((Object)this.entryListener, (CacheEventFilter)new EventFilter(), (CacheEventConverter)new EventConverter(), filterAnnotations);
    }

    public CompletableFuture<List<RegistrationInfo>> get(String address) {
        return this.subsCache.get((Object)address).thenApply(collection -> collection.stream().map(DataConverter::fromCachedObject).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> put(String address, RegistrationInfo registrationInfo) {
        return this.subsCache.put((Object)address, (Object)DataConverter.toCachedObject(registrationInfo));
    }

    public CompletableFuture<Void> remove(String address, RegistrationInfo registrationInfo) {
        return this.subsCache.remove((Object)address, (Object)DataConverter.toCachedObject(registrationInfo)).thenApply(v -> null);
    }

    public void removeAllForNode(String nodeId) {
        this.subsCache.remove((SerializablePredicate & Serializable)value -> nodeId.equals(((RegistrationInfo)DataConverter.fromCachedObject(value)).nodeId()));
    }

    public void close() {
        this.subsCache.getCache().removeListener((Object)this.entryListener);
    }

    private void fireRegistrationUpdateEvent(String address) {
        this.get(address).whenComplete((registrationInfos, throwable) -> {
            if (throwable == null) {
                this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, registrationInfos));
            } else {
                log.trace((Object)"A failure occured while retrieving the updated registrations", throwable);
                this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, Collections.emptyList()));
            }
        });
    }

    private static class EventConverter
    implements CacheEventConverter<String, Bucket<byte[]>, Void> {
        private EventConverter() {
        }

        public Void convert(String key, Bucket<byte[]> oldValue, Metadata oldMetadata, Bucket<byte[]> newValue, Metadata newMetadata, EventType eventType) {
            return null;
        }
    }

    private static class EventFilter
    implements CacheEventFilter<String, Bucket<byte[]>> {
        public boolean accept(String key, Bucket<byte[]> oldValue, Metadata oldMetadata, Bucket<byte[]> newValue, Metadata newMetadata, EventType eventType) {
            return true;
        }
    }

    @Listener(clustered=true, observation=Listener.Observation.POST, sync=false)
    private class EntryListener {
        @CacheEntryCreated
        public void entryCreated(CacheEntryCreatedEvent<String, Void> event) {
            SubsCacheHelper.this.fireRegistrationUpdateEvent((String)event.getKey());
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent<String, Void> event) {
            SubsCacheHelper.this.fireRegistrationUpdateEvent((String)event.getKey());
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent<String, Void> event) {
            SubsCacheHelper.this.fireRegistrationUpdateEvent((String)event.getKey());
        }
    }
}

