/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.jdbcclient.JDBCConnectOptions;
import java.util.Base64;
import java.util.Map;

public class JDBCConnectOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JDBCConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "dataSourceImplementation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDataSourceImplementation((String)member.getValue());
                    break;
                }
                case "database": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatabase((String)member.getValue());
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "jdbcUrl": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setJdbcUrl((String)member.getValue());
                    break;
                }
                case "metricsEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setMetricsEnabled((Boolean)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(JDBCConnectOptions obj, JsonObject json) {
        JDBCConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JDBCConnectOptions obj, Map<String, Object> json) {
        json.put("connectTimeout", obj.getConnectTimeout());
        if (obj.getDataSourceImplementation() != null) {
            json.put("dataSourceImplementation", obj.getDataSourceImplementation());
        }
        if (obj.getDatabase() != null) {
            json.put("database", obj.getDatabase());
        }
        json.put("idleTimeout", obj.getIdleTimeout());
        if (obj.getJdbcUrl() != null) {
            json.put("jdbcUrl", obj.getJdbcUrl());
        }
        json.put("metricsEnabled", obj.isMetricsEnabled());
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
    }
}

