/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

import io.vertx.ext.jwt.Crypto;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

final class CryptoPublicKey
implements Crypto {
    private final Signature sig;
    private final PublicKey publicKey;

    CryptoPublicKey(String algorithm, PublicKey publicKey) {
        Signature signature;
        this.publicKey = publicKey;
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.sig = signature;
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        throw new RuntimeException("CryptoPublicKey cannot sign");
    }

    @Override
    public synchronized boolean verify(byte[] signature, byte[] payload) {
        try {
            this.sig.initVerify(this.publicKey);
            this.sig.update(payload);
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

