/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

import io.vertx.ext.jwt.Crypto;
import io.vertx.ext.jwt.CryptoMac;
import io.vertx.ext.jwt.CryptoSignature;
import io.vertx.ext.jwt.JWT;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class CryptoTest {
    @Test
    public void test_mac_signVerify() throws Exception {
        CryptoMac crypto = this.getMac();
        byte[] payload = "World!".getBytes(StandardCharsets.UTF_8);
        byte[] hash = crypto.sign(payload);
        Assert.assertArrayEquals((byte[])Base64.getDecoder().decode("aNlISkpF3OORSLOWrmLonO+R/TREP/3ENb5UuEHjczE="), (byte[])hash);
        Assert.assertTrue((boolean)crypto.verify(hash, payload));
    }

    @Test
    public void test_mac_concurrentSignVerify() throws Throwable {
        CryptoMac crypto = this.getMac();
        byte[] payload = "World!".getBytes(StandardCharsets.UTF_8);
        this.concurrentSignVerify((Crypto)crypto, payload, "aNlISkpF3OORSLOWrmLonO+R/TREP/3ENb5UuEHjczE=");
    }

    @Test
    public void test_signature_signVerify() throws Exception {
        CryptoSignature crypto = this.getSignature();
        byte[] payload = "World!".getBytes(StandardCharsets.UTF_8);
        byte[] signature = crypto.sign(payload);
        Assert.assertArrayEquals((byte[])Base64.getDecoder().decode("Gncqp+4rDGS1fjU+qhIF1ky2m7HGS+LfcgWHffDQL97QJVRsiJy+ZKghTpyujIV+tX6KQDb5HJsR2tP7TwsUGHSvPyY8clZvrwlCshAWI6cpdRM2udIawvzwDu0iaCrfbwMQxeQvz53nX2AkPuCSYE6fgpb9hi8xqzxDHheTwV8L2aBv1L9pVRy5yJCpWe4vMSqBOLajD+bKMD0evRc2v9gxr2ugJ1okSXu8RnOYAzRcaNMl7R/YjR+i5jYUFjD1KrdYz+JsBVONKtZEYoY3IKJBTir/Wl6uqnGlDD0hMisRWpm8Umks1GbZTAFrJ5zMftb0ctQxXdzCf+YH5/57PQ=="), (byte[])signature);
        Assert.assertTrue((boolean)crypto.verify(signature, payload));
    }

    @Test
    public void test_signature_concurrentSignVerify() throws Exception {
        CryptoSignature crypto = this.getSignature();
        byte[] payload = "World!".getBytes(StandardCharsets.UTF_8);
        this.concurrentSignVerify((Crypto)crypto, payload, "Gncqp+4rDGS1fjU+qhIF1ky2m7HGS+LfcgWHffDQL97QJVRsiJy+ZKghTpyujIV+tX6KQDb5HJsR2tP7TwsUGHSvPyY8clZvrwlCshAWI6cpdRM2udIawvzwDu0iaCrfbwMQxeQvz53nX2AkPuCSYE6fgpb9hi8xqzxDHheTwV8L2aBv1L9pVRy5yJCpWe4vMSqBOLajD+bKMD0evRc2v9gxr2ugJ1okSXu8RnOYAzRcaNMl7R/YjR+i5jYUFjD1KrdYz+JsBVONKtZEYoY3IKJBTir/Wl6uqnGlDD0hMisRWpm8Umks1GbZTAFrJ5zMftb0ctQxXdzCf+YH5/57PQ==");
    }

    @Test
    public void ecdsaSignatureComplianceTest() throws Exception {
        JWT jwt = new JWT().addPublicKey("ES512", "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQASisgweVL1tAtIvfmpoqvdXF8sPKTV9YTKNxBwkdkm+/auh4pR8TbaIfsEzcsGUVv61DFNFXb0ozJfurQ59G2XcgAn3vROlSSnpbIvuhKrzL5jwWDTaYa5tVF1Zjwia/5HUhKBkcPuWGXg05nMjWhZfCuEetzMLoGcHmtvabugFrqsAg=");
        TestCase.assertFalse((boolean)jwt.isUnsecure());
        Assert.assertNotNull((Object)jwt.decode("eyJhbGciOiJFUzUxMiIsInR5cCI6IkpXVCJ9.eyJ0ZXN0IjoidGVzdCIsImlhdCI6MTQ2NzA2NTgyN30.Aab4x7HNRzetjgZ88AMGdYV2Ml7kzFbl8Ql2zXvBores7iRqm2nK6810ANpVo5okhHa82MQf2Q_Zn4tFyLDR9z4GAcKFdcAtopxq1h8X58qBWgNOc0Bn40SsgUc8wOX4rFohUCzEtnUREePsvc9EfXjjAH78WD2nq4tn-N94vf14SncQ"));
        Assert.assertNotNull((Object)jwt.decode("eyJ0eXAiOiJKV1QiLCJhbGciOiJFUzUxMiJ9.eyJ0ZXN0IjoidGVzdCJ9.AV26tERbSEwcoDGshneZmhokg-tAKUk0uQBoHBohveEd51D5f6EIs6cskkgwtfzs4qAGfx2rYxqQXr7LTXCNquKiAJNkTIKVddbPfped3_TQtmHZTmMNiqmWjiFj7Y9eTPMMRRu26w4gD1a8EQcBF-7UGgeH4L_1CwHJWAXGbtu7uMUn"));
    }

    private void concurrentSignVerify(Crypto crypto, byte[] payload, String expected) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(8);
        ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        CountDownLatch initialLatch = new CountDownLatch(8);
        CountDownLatch finalLatch = new CountDownLatch(8);
        IntStream.range(0, 8).forEach(i -> pool.submit(() -> {
            try {
                initialLatch.countDown();
                initialLatch.await(10L, TimeUnit.SECONDS);
                if (i % 2 == 0) {
                    Assert.assertArrayEquals((String)"sign failed", (byte[])Base64.getDecoder().decode(expected), (byte[])crypto.sign(payload));
                } else {
                    Assert.assertTrue((String)"verify failed", (boolean)crypto.verify(Base64.getDecoder().decode(expected), payload));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                exceptions.add(e);
            }
            finally {
                finalLatch.countDown();
            }
        }));
        finalLatch.await();
        Assert.assertEquals((String)exceptions.stream().map(Throwable::getMessage).reduce("", (a, b) -> a + System.lineSeparator() + b), (long)0L, (long)exceptions.size());
    }

    private CryptoMac getMac() throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec("Hello".getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        return new CryptoMac(mac);
    }

    private CryptoSignature getSignature() throws Exception {
        KeyStore ks = KeyStore.getInstance("jks");
        try (InputStream in = CryptoTest.class.getResourceAsStream("/gce.jks");){
            ks.load(in, "notasecret".toCharArray());
        }
        X509Certificate publicKey = (X509Certificate)ks.getCertificate("RS256");
        PrivateKey privateKey = (PrivateKey)ks.getKey("RS256", "notasecret".toCharArray());
        return new CryptoSignature("SHA256withRSA", publicKey, privateKey);
    }
}

