/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kotlin.coroutines;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0014\u0018\u00010\u0006H\u0016J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J+\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00028\u00002\u0014\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0014\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/vertx/kotlin/coroutines/TestStream;", "T", "Lio/vertx/core/streams/ReadStream;", "Lio/vertx/core/streams/WriteStream;", "()V", "drainHandler", "Lio/vertx/core/Handler;", "Ljava/lang/Void;", "endHandler", "handler", "<set-?>", "", "isEnded", "()Z", "paused", "writtenElements", "", "end", "", "completionHandler", "Lio/vertx/core/AsyncResult;", "exceptionHandler", "", "fetch", "amount", "pause", "resume", "setWriteQueueMaxSize", "size", "", "write", "Lio/vertx/core/Future;", "data", "(Ljava/lang/Object;)Lio/vertx/core/Future;", "(Ljava/lang/Object;Lio/vertx/core/Handler;)V", "writeQueueFull", "vertx-lang-kotlin-coroutines"})
public final class TestStream<T>
implements ReadStream<T>,
WriteStream<T> {
    private boolean isEnded;
    private boolean paused;
    private Handler<T> handler;
    private Handler<Void> drainHandler;
    private Handler<Void> endHandler;
    private long writtenElements;

    public final boolean isEnded() {
        return this.isEnded;
    }

    @NotNull
    public TestStream<T> exceptionHandler(@NotNull Handler<Throwable> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this;
    }

    @NotNull
    public TestStream<T> handler(@NotNull Handler<T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.handler = handler;
        return this;
    }

    @NotNull
    public ReadStream<T> fetch(long amount) {
        this.writtenElements -= amount;
        if (this.writtenElements <= 0L && this.paused) {
            this.paused = false;
            this.writtenElements = 0L;
        }
        return this;
    }

    @NotNull
    public TestStream<T> pause() {
        if (!this.isEnded) {
            this.paused = true;
        }
        return this;
    }

    @NotNull
    public TestStream<T> resume() {
        if (this.paused) {
            this.paused = false;
            Handler<Void> handler = this.drainHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"drainHandler");
            }
            handler.handle(null);
        }
        return this;
    }

    @NotNull
    public TestStream<T> endHandler(@NotNull Handler<Void> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.endHandler = handler;
        return this;
    }

    @NotNull
    public Future<Void> write(T data) {
        Promise promise = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)promise));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    public void write(T data, @Nullable Handler<AsyncResult<Void>> completionHandler) {
        Handler<T> handler = this.handler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handler");
        }
        handler.handle(data);
        long l = this.writtenElements;
        this.writtenElements = l + 1L;
        if (completionHandler != null) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    public void end(@Nullable Handler<AsyncResult<Void>> completionHandler) {
        this.isEnded = true;
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            handler.handle(null);
        }
        if (completionHandler != null) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    @NotNull
    public TestStream<T> setWriteQueueMaxSize(int size) {
        return this;
    }

    public boolean writeQueueFull() {
        return this.paused;
    }

    @NotNull
    public TestStream<T> drainHandler(@NotNull Handler<Void> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.drainHandler = handler;
        return this;
    }
}

