/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kotlin.coroutines;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\tj\u0002`\b\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010#\u001a\u00020$J\n\u0010%\u001a\u0004\u0018\u00010\u0002H\u0016J\u001b\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\b\u0010'\u001a\u00020\u001aH\u0016J\u0017\u0010(\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\fH\u0016J\u0011\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\u00060\tj\u0002`\b\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00062"}, d2={"Lio/vertx/kotlin/coroutines/VertxScheduledFuture;", "Ljava/util/concurrent/ScheduledFuture;", "", "Lio/vertx/core/Handler;", "", "vertxContext", "Lio/vertx/core/Context;", "task", "Lkotlinx/coroutines/Runnable;", "Ljava/lang/Runnable;", "delay", "unit", "Ljava/util/concurrent/TimeUnit;", "<init>", "(Lio/vertx/core/Context;Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)V", "getVertxContext", "()Lio/vertx/core/Context;", "getTask", "()Ljava/lang/Runnable;", "Ljava/lang/Runnable;", "getDelay", "()J", "getUnit", "()Ljava/util/concurrent/TimeUnit;", "completion", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getCompletion", "()Ljava/util/concurrent/atomic/AtomicReference;", "id", "getId", "()Ljava/lang/Long;", "setId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "schedule", "", "get", "timeout", "isCancelled", "handle", "event", "cancel", "mayInterruptIfRunning", "isDone", "u", "compareTo", "", "other", "Ljava/util/concurrent/Delayed;", "vertx-lang-kotlin-coroutines"})
final class VertxScheduledFuture
implements ScheduledFuture<Object>,
Handler<Long> {
    @NotNull
    private final Context vertxContext;
    @NotNull
    private final Runnable task;
    private final long delay;
    @NotNull
    private final TimeUnit unit;
    @NotNull
    private final AtomicReference<Boolean> completion;
    @Nullable
    private Long id;

    public VertxScheduledFuture(@NotNull Context vertxContext, @NotNull Runnable task, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)vertxContext, (String)"vertxContext");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.vertxContext = vertxContext;
        this.task = task;
        this.delay = delay;
        this.unit = unit;
        this.completion = new AtomicReference();
    }

    @NotNull
    public final Context getVertxContext() {
        return this.vertxContext;
    }

    @NotNull
    public final Runnable getTask() {
        return this.task;
    }

    public final long getDelay() {
        return this.delay;
    }

    @NotNull
    public final TimeUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final AtomicReference<Boolean> getCompletion() {
        return this.completion;
    }

    @Nullable
    public final Long getId() {
        return this.id;
    }

    public final void setId(@Nullable Long l) {
        this.id = l;
    }

    public final void schedule() {
        Vertx owner = this.vertxContext.owner();
        this.id = owner.setTimer(this.unit.toMillis(this.delay), (Handler)this);
    }

    @Override
    @Nullable
    public Object get() {
        return null;
    }

    @Override
    @Nullable
    public Object get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return null;
    }

    @Override
    public boolean isCancelled() {
        return Intrinsics.areEqual((Object)this.completion.get(), (Object)false);
    }

    public void handle(@Nullable Long event) {
        if (this.completion.compareAndSet(null, true)) {
            this.task.run();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        if (this.completion.compareAndSet(null, false)) {
            Vertx vertx = this.vertxContext.owner();
            Long l = this.id;
            Intrinsics.checkNotNull((Object)l);
            bl = vertx.cancelTimer(l.longValue());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDone() {
        return Intrinsics.areEqual((Object)this.completion.get(), (Object)true);
    }

    @Override
    public long getDelay(@NotNull TimeUnit u) {
        Intrinsics.checkNotNullParameter((Object)((Object)u), (String)"u");
        return u.convert(this.unit.toNanos(this.delay), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(@NotNull Delayed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.getDelay(TimeUnit.NANOSECONDS), (long)other.getDelay(TimeUnit.NANOSECONDS));
    }
}

