/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.kotlin.test;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.kotlin.core.json.Json;
import io.vertx.kotlin.core.json.JsonKt;
import io.vertx.lang.kotlin.test.JsonTest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.test.AssertionsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lio/vertx/lang/kotlin/test/JsonTest;", "", "()V", "smoke", "", "testAppendJson", "testArrays", "testByteArrayProcessing", "testIndexAccessor", "testInferenceArray", "testInferenceObj", "testInstantProcessing", "testKeyAccessor", "testMapToObj", "testNormalProcessing", "testWriteJson", "typeInference", "User", "vertx-lang-kotlin"})
public final class JsonTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public final void smoke() {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"a", (Object)JsonKt.array((Json)$this$json, (Object[])new Object[]{1, 2, 3}));
        pairArray[1] = TuplesKt.to((Object)"obj", (Object)JsonKt.obj((Json)$this$json, (Pair[])new Pair[]{TuplesKt.to((Object)"b1", (Object)1), TuplesKt.to((Object)"b2", (Object)"2")}));
        pairArray[2] = TuplesKt.to((Object)"imperative-loop", (Object)JsonKt.obj((Json)$this$json, (Function1)smoke.result.1.1.INSTANCE));
        int n = 1;
        Iterable iterable = (Iterable)new IntRange(n, 3);
        Json json = $this$json;
        String string = "map";
        int n2 = 3;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        Json json2 = $this$json;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)("k_" + (int)it), (Object)((int)it));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        pairArray2[n2] = TuplesKt.to((Object)string, (Object)JsonKt.obj((Json)json, (Iterable)collection));
        pairArray3[4] = TuplesKt.to((Object)"d", (Object)"d");
        JsonObject result2 = JsonKt.obj((Json)json2, (Pair[])pairArray3);
        AssertionsKt.assertTrue$default(null, (Function0)((Function0)new Function0<Boolean>(result2){
            final /* synthetic */ JsonObject $result;

            public final boolean invoke() {
                return this.$result instanceof JsonObject;
            }
            {
                this.$result = jsonObject;
                super(0);
            }
        }), (int)1, null);
        String string2 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        AssertionsKt.assertEquals$default((Object)"{\"a\":[1,2,3],\"obj\":{\"b1\":1,\"b2\":\"2\"},\"imperative-loop\":{\"k_1\":1,\"k_2\":2,\"k_3\":3},\"map\":{\"k_1\":1,\"k_2\":2,\"k_3\":3},\"d\":\"d\"}", (Object)string2, null, (int)4, null);
    }

    @Test
    public final void testMapToObj() {
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonObject result2 = JsonKt.obj((Json)$this$json, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"k", (Object)"v")));
        AssertionsKt.assertTrue$default(null, (Function0)((Function0)new Function0<Boolean>(result2){
            final /* synthetic */ JsonObject $result;

            public final boolean invoke() {
                return this.$result instanceof JsonObject;
            }
            {
                this.$result = jsonObject;
                super(0);
            }
        }), (int)1, null);
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        AssertionsKt.assertEquals$default((Object)"{\"k\":\"v\"}", (Object)string, null, (int)4, null);
    }

    @Test
    public final void testArrays() {
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonArray result2 = JsonKt.array((Json)$this$json, (Object[])new Object[]{JsonKt.array((Json)$this$json, (Object[])new Object[]{1, 2, 3}), JsonKt.array((Json)$this$json, (Iterable)CollectionsKt.listOf((Object[])new Integer[]{4, 5, 6})), JsonKt.array((Json)$this$json, (Iterable)SetsKt.setOf((Object)7)), JsonKt.array((Json)$this$json, (Function1)testArrays.result.1.1.INSTANCE)});
        AssertionsKt.assertTrue$default(null, (Function0)((Function0)new Function0<Boolean>(result2){
            final /* synthetic */ JsonArray $result;

            public final boolean invoke() {
                return this.$result instanceof JsonArray;
            }
            {
                this.$result = jsonArray;
                super(0);
            }
        }), (int)1, null);
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        AssertionsKt.assertEquals$default((Object)"[[1,2,3],[4,5,6],[7],[8,9,10]]", (Object)string, null, (int)4, null);
    }

    @Test
    public final void typeInference() {
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonObject r1 = JsonKt.obj((Json)$this$json, (Pair[])new Pair[0]);
        boolean $i$f$json2 = false;
        Json $this$json2 = Json.INSTANCE;
        boolean bl2 = false;
        JsonArray r2 = JsonKt.array((Json)$this$json2, (Object[])new Object[0]);
        AssertionsKt.assertNotNull$default((Object)r1, null, (int)2, null);
        AssertionsKt.assertNotNull$default((Object)r2, null, (int)2, null);
    }

    @Test
    public final void testIndexAccessor() {
        Integer n = 1;
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonArray jsonArray = JsonKt.array((Json)$this$json, (Object[])new Object[]{1});
        AssertionsKt.assertEquals$default((Object)n, (Object)JsonKt.get((JsonArray)jsonArray, (int)0), null, (int)4, null);
    }

    @Test
    public final void testKeyAccessor() {
        String string = "v";
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonObject jsonObject = JsonKt.obj((Json)$this$json, (Pair[])new Pair[]{TuplesKt.to((Object)"k", (Object)"v")});
        AssertionsKt.assertEquals$default((Object)string, (Object)JsonKt.get((JsonObject)jsonObject, (String)"k"), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testAppendJson() {
        void $this$appendJson$iv;
        Buffer buffer = Buffer.buffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer, (String)"Buffer.buffer()");
        Buffer $this$appendJson$iv2 = buffer;
        boolean pretty$iv = false;
        boolean $i$f$appendJson = false;
        Object $this$appendJson = Json.INSTANCE;
        boolean bl = false;
        Object object = JsonKt.obj((Json)$this$appendJson, (Pair[])new Pair[]{TuplesKt.to((Object)"k", (Object)"v")});
        boolean bl2 = false;
        boolean bl3 = false;
        JsonObject json$iv = object;
        boolean bl4 = false;
        object = io.vertx.core.json.Json.encode((Object)json$iv);
        bl2 = false;
        bl3 = false;
        Object encoded$iv = object;
        boolean bl5 = false;
        Buffer buffer2 = $this$appendJson$iv2.appendString((String)encoded$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer2, (String)"appendString(encoded)");
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer2, (String)"block(Json).let { json -\u2026> appendString(encoded) }");
        Buffer b = buffer2;
        AssertionsKt.assertEquals$default((Object)"{\"k\":\"v\"}", (Object)b.toString(Charsets.UTF_8), null, (int)4, null);
        Buffer buffer3 = Buffer.buffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer3, (String)"Buffer.buffer()");
        Buffer $this$appendJson$iv3 = buffer3;
        boolean pretty$iv22 = false;
        boolean $i$f$appendJson2 = false;
        Json $this$appendJson2 = Json.INSTANCE;
        boolean bl6 = false;
        $this$appendJson = new User("Julien", "Viet");
        bl3 = false;
        boolean bl7 = false;
        Object json$iv2 = $this$appendJson;
        $i$a$-let-BufferKt$appendJson$1 = false;
        $this$appendJson = io.vertx.core.json.Json.encode((Object)json$iv2);
        bl3 = false;
        bl7 = false;
        Object encoded$iv2 = $this$appendJson;
        $i$a$-let-BufferKt$appendJson$2 = false;
        Buffer buffer4 = $this$appendJson$iv3.appendString((String)encoded$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer4, (String)"appendString(encoded)");
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer4, (String)"block(Json).let { json -\u2026> appendString(encoded) }");
        Buffer c = buffer4;
        AssertionsKt.assertEquals$default((Object)"{\"firstName\":\"Julien\",\"lastName\":\"Viet\"}", (Object)c.toString(Charsets.UTF_8), null, (int)4, null);
        Buffer buffer5 = Buffer.buffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer5, (String)"Buffer.buffer()");
        Buffer pretty$iv22 = buffer5;
        boolean pretty$iv3 = true;
        boolean $i$f$appendJson3 = false;
        Json $receiver = Json.INSTANCE;
        boolean bl8 = false;
        Object object2 = new User("Julien", "Viet");
        bl7 = false;
        boolean bl9 = false;
        User json$iv3 = object2;
        $i$a$-let-BufferKt$appendJson$1 = false;
        object2 = io.vertx.core.json.Json.encodePrettily((Object)json$iv3);
        bl7 = false;
        bl9 = false;
        Object encoded$iv3 = object2;
        $i$a$-let-BufferKt$appendJson$2 = false;
        Buffer buffer6 = $this$appendJson$iv.appendString((String)encoded$iv3);
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer6, (String)"appendString(encoded)");
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer6, (String)"block(Json).let { json -\u2026> appendString(encoded) }");
        Buffer d = buffer6;
        AssertionsKt.assertEquals$default((Object)"{\n  \"firstName\" : \"Julien\",\n  \"lastName\" : \"Viet\"\n}", (Object)d.toString(Charsets.UTF_8), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testWriteJson() {
        void $this$appendJson$iv$iv;
        void $this$appendJson$iv$iv2;
        ArrayList received = new ArrayList();
        AtomicBoolean ended = new AtomicBoolean();
        WriteStream<Buffer> ws2 = new WriteStream<Buffer>(received, ended){
            final /* synthetic */ ArrayList $received;
            final /* synthetic */ AtomicBoolean $ended;

            @NotNull
            public Future<Void> write(@Nullable Buffer data) {
                Buffer buffer = data;
                if (buffer != null) {
                    Buffer buffer2 = buffer;
                    boolean bl = false;
                    boolean bl2 = false;
                    Buffer it = buffer2;
                    boolean bl3 = false;
                    this.$received.add(it);
                }
                Future future = Future.succeededFuture();
                Intrinsics.checkExpressionValueIsNotNull((Object)future, (String)"Future.succeededFuture()");
                return future;
            }

            public boolean writeQueueFull() {
                throw (Throwable)new UnsupportedOperationException("not implemented");
            }

            public void write(@Nullable Buffer data, @Nullable Handler<AsyncResult<Void>> handler) {
                block1: {
                    Buffer buffer = data;
                    if (buffer != null) {
                        Buffer buffer2 = buffer;
                        boolean bl = false;
                        boolean bl2 = false;
                        Buffer it = buffer2;
                        boolean bl3 = false;
                        this.$received.add(it);
                    }
                    Handler<AsyncResult<Void>> handler2 = handler;
                    if (handler2 == null) break block1;
                    handler2.handle((Object)Future.succeededFuture());
                }
            }

            public void end(@Nullable Handler<AsyncResult<Void>> handler) {
                block0: {
                    this.$ended.set(true);
                    Handler<AsyncResult<Void>> handler2 = handler;
                    if (handler2 == null) break block0;
                    handler2.handle((Object)Future.succeededFuture());
                }
            }

            @NotNull
            public WriteStream<Buffer> drainHandler(@Nullable Handler<Void> handler) {
                throw (Throwable)new UnsupportedOperationException("not implemented");
            }

            @NotNull
            public WriteStream<Buffer> exceptionHandler(@Nullable Handler<Throwable> handler) {
                throw (Throwable)new UnsupportedOperationException("not implemented");
            }

            @NotNull
            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                throw (Throwable)new UnsupportedOperationException("not implemented");
            }
            {
                this.$received = $captured_local_variable$0;
                this.$ended = $captured_local_variable$1;
            }
        };
        WriteStream $this$write$iv = (WriteStream)ws2;
        boolean pretty$iv = false;
        boolean $i$f$write = false;
        Buffer buffer = Buffer.buffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer, (String)"Buffer.buffer()");
        Buffer buffer2 = buffer;
        WriteStream writeStream = $this$write$iv;
        boolean $i$f$appendJson = false;
        Json $this$write = Json.INSTANCE;
        boolean bl = false;
        Object object = JsonKt.obj((Json)$this$write, (Pair[])new Pair[]{TuplesKt.to((Object)"k", (Object)"v")});
        boolean bl2 = false;
        boolean bl3 = false;
        JsonObject json$iv$iv = object;
        boolean bl4 = false;
        object = io.vertx.core.json.Json.encode((Object)json$iv$iv);
        bl2 = false;
        bl3 = false;
        Object encoded$iv$iv = object;
        boolean bl5 = false;
        Buffer buffer3 = $this$appendJson$iv$iv2.appendString((String)encoded$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer3, (String)"appendString(encoded)");
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer3, (String)"block(Json).let { json -\u2026> appendString(encoded) }");
        $this$write = buffer3;
        writeStream.write((Object)$this$write);
        AssertionsKt.assertEquals$default((Object)1, (Object)received.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"{\"k\":\"v\"}", (Object)((Buffer)CollectionsKt.single((List)received)).toString(Charsets.UTF_8), null, (int)4, null);
        AssertionsKt.assertFalse$default((boolean)ended.get(), null, (int)2, null);
        received.clear();
        Function1 block2 = testWriteJson.block.1.INSTANCE;
        WriteStream $this$end$iv = (WriteStream)ws2;
        boolean pretty$iv2 = false;
        boolean $i$f$end = false;
        Buffer buffer4 = Buffer.buffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer4, (String)"Buffer.buffer()");
        writeStream = buffer4;
        WriteStream writeStream2 = $this$end$iv;
        boolean $i$f$appendJson2 = false;
        Json $receiver = Json.INSTANCE;
        boolean bl6 = false;
        Object object2 = JsonKt.obj((Json)$receiver, (Pair[])new Pair[]{TuplesKt.to((Object)"k", (Object)"v")});
        bl3 = false;
        boolean bl7 = false;
        JsonObject json$iv$iv2 = object2;
        $i$a$-let-BufferKt$appendJson$1 = false;
        object2 = io.vertx.core.json.Json.encode((Object)json$iv$iv2);
        bl3 = false;
        bl7 = false;
        Object encoded$iv$iv2 = object2;
        $i$a$-let-BufferKt$appendJson$2 = false;
        Buffer buffer5 = $this$appendJson$iv$iv.appendString((String)encoded$iv$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer5, (String)"appendString(encoded)");
        Intrinsics.checkExpressionValueIsNotNull((Object)buffer5, (String)"block(Json).let { json -\u2026> appendString(encoded) }");
        Buffer buffer6 = buffer5;
        writeStream2.end((Object)buffer6);
        AssertionsKt.assertEquals$default((Object)1, (Object)received.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"{\"k\":\"v\"}", (Object)((Buffer)CollectionsKt.single((List)received)).toString(Charsets.UTF_8), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)ended.get(), null, (int)2, null);
    }

    @Test
    public final void testInferenceObj() {
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonArray arr = JsonKt.array((Json)$this$json, (JsonObject)JsonKt.obj((Json)$this$json, (Pair[])new Pair[]{TuplesKt.to((Object)"foo", (Object)"foo_value")}));
        JsonObject jsonObject = arr.getJsonObject(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"arr.getJsonObject(0)");
        JsonObject obj = jsonObject;
        AssertionsKt.assertNotNull$default((Object)obj, null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)"foo_value", (Object)obj.getString("foo"), null, (int)4, null);
    }

    @Test
    public final void testInferenceArray() {
        boolean $i$f$json = false;
        Json $this$json = Json.INSTANCE;
        boolean bl = false;
        JsonArray arr = JsonKt.array((Json)$this$json, (JsonArray)JsonKt.array((Json)$this$json, (Object[])new Object[]{1}));
        JsonArray jsonArray = arr.getJsonArray(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"arr.getJsonArray(0)");
        JsonArray subArray = jsonArray;
        AssertionsKt.assertNotNull$default((Object)subArray, null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)subArray.getInteger(0), null, (int)4, null);
    }

    @Test
    public final void testInstantProcessing() {
        Instant expected = Instant.now();
        JsonObject json = JsonKt.jsonObjectOf((Pair[])new Pair[]{TuplesKt.to((Object)"time", (Object)expected)});
        Instant actual = json.getInstant("time");
        AssertionsKt.assertEquals$default((Object)expected, (Object)actual, null, (int)4, null);
    }

    @Test
    public final void testByteArrayProcessing() {
        byte[] expected = new byte[]{0, 1, 2};
        JsonObject json = JsonKt.jsonObjectOf((Pair[])new Pair[]{TuplesKt.to((Object)"bytes", (Object)expected)});
        byte[] actual = json.getBinary("bytes");
        AssertionsKt.assertEquals$default((Object)expected[0], (Object)actual[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)expected[1], (Object)actual[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)expected[2], (Object)actual[2], null, (int)4, null);
    }

    @Test
    public final void testNormalProcessing() {
        String expected = "A Value";
        JsonObject json = JsonKt.jsonObjectOf((Pair[])new Pair[]{TuplesKt.to((Object)"key", (Object)expected)});
        String actual = json.getString("key");
        AssertionsKt.assertEquals$default((Object)expected, (Object)actual, null, (int)4, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lio/vertx/lang/kotlin/test/JsonTest$User;", "", "firstName", "", "lastName", "(Ljava/lang/String;Ljava/lang/String;)V", "getFirstName", "()Ljava/lang/String;", "getLastName", "vertx-lang-kotlin"})
    public static final class User {
        @NotNull
        private final String firstName;
        @NotNull
        private final String lastName;

        @NotNull
        public final String getFirstName() {
            return this.firstName;
        }

        @NotNull
        public final String getLastName() {
            return this.lastName;
        }

        public User(@NotNull String firstName, @NotNull String lastName) {
            Intrinsics.checkParameterIsNotNull((Object)firstName, (String)"firstName");
            Intrinsics.checkParameterIsNotNull((Object)lastName, (String)"lastName");
            this.firstName = firstName;
            this.lastName = lastName;
        }
    }
}

