/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.jdbcclient

import io.vertx.jdbcclient.JDBCConnectOptions
import io.vertx.core.tracing.TracingPolicy
import io.vertx.ext.sql.FetchDirection
import io.vertx.ext.sql.ResultSetConcurrency
import io.vertx.ext.sql.ResultSetType
import io.vertx.ext.sql.TransactionIsolation

fun jdbcConnectOptionsOf(
  autoGeneratedKeys: Boolean? = null,
  autoGeneratedKeysIndexes: io.vertx.core.json.JsonArray? = null,
  catalog: String? = null,
  connectTimeout: Int? = null,
  dataSourceImplementation: String? = null,
  database: String? = null,
  fetchDirection: FetchDirection? = null,
  fetchSize: Int? = null,
  idleTimeout: Int? = null,
  jdbcUrl: String? = null,
  maxRows: Int? = null,
  metricsEnabled: Boolean? = null,
  password: String? = null,
  queryTimeout: Int? = null,
  readOnly: Boolean? = null,
  resultSetConcurrency: ResultSetConcurrency? = null,
  resultSetType: ResultSetType? = null,
  schema: String? = null,
  tracingPolicy: TracingPolicy? = null,
  transactionIsolation: TransactionIsolation? = null,
  user: String? = null): JDBCConnectOptions = io.vertx.jdbcclient.JDBCConnectOptions().apply {

  if (autoGeneratedKeys != null) {
    this.setAutoGeneratedKeys(autoGeneratedKeys)
  }
  if (autoGeneratedKeysIndexes != null) {
    this.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes)
  }
  if (catalog != null) {
    this.setCatalog(catalog)
  }
  if (connectTimeout != null) {
    this.setConnectTimeout(connectTimeout)
  }
  if (dataSourceImplementation != null) {
    this.setDataSourceImplementation(dataSourceImplementation)
  }
  if (database != null) {
    this.setDatabase(database)
  }
  if (fetchDirection != null) {
    this.setFetchDirection(fetchDirection)
  }
  if (fetchSize != null) {
    this.setFetchSize(fetchSize)
  }
  if (idleTimeout != null) {
    this.setIdleTimeout(idleTimeout)
  }
  if (jdbcUrl != null) {
    this.setJdbcUrl(jdbcUrl)
  }
  if (maxRows != null) {
    this.setMaxRows(maxRows)
  }
  if (metricsEnabled != null) {
    this.setMetricsEnabled(metricsEnabled)
  }
  if (password != null) {
    this.setPassword(password)
  }
  if (queryTimeout != null) {
    this.setQueryTimeout(queryTimeout)
  }
  if (readOnly != null) {
    this.setReadOnly(readOnly)
  }
  if (resultSetConcurrency != null) {
    this.setResultSetConcurrency(resultSetConcurrency)
  }
  if (resultSetType != null) {
    this.setResultSetType(resultSetType)
  }
  if (schema != null) {
    this.setSchema(schema)
  }
  if (tracingPolicy != null) {
    this.setTracingPolicy(tracingPolicy)
  }
  if (transactionIsolation != null) {
    this.setTransactionIsolation(transactionIsolation)
  }
  if (user != null) {
    this.setUser(user)
  }
}

