require 'vertx-amqp-client/amqp_message'
require 'vertx/buffer'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpMessageBuilder
module VertxAmqpClient
  #  Builder to create a new {::VertxAmqpClient::AmqpMessage}.
  #  <p>
  #  Reference about the different metadata can be found on
  #  <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
  #  <p>
  #  Note that the body is set using <code>withBodyAs*</code> method depending on the passed type.
  class AmqpMessageBuilder
    # @private
    # @param j_del [::VertxAmqpClient::AmqpMessageBuilder] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpMessageBuilder] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpMessageBuilder
    end
    def @@j_api_type.wrap(obj)
      AmqpMessageBuilder.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpMessageBuilder.java_class
    end
    # @return [::VertxAmqpClient::AmqpMessageBuilder] a new instance of {::VertxAmqpClient::AmqpMessageBuilder}
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpMessageBuilder.java_method(:create, []).call(),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
    # @return [::VertxAmqpClient::AmqpMessage] the message.
    def build
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:build, []).call(),::VertxAmqpClient::AmqpMessage)
      end
      raise ArgumentError, "Invalid arguments when calling build()"
    end
    # @param [Fixnum] priority 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def priority(priority=nil)
      if priority.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:priority, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(priority)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling priority(#{priority})"
    end
    # @param [true,false] durable 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def durable(durable=nil)
      if (durable.class == TrueClass || durable.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:durable, [Java::boolean.java_class]).call(durable),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling durable(#{durable})"
    end
    # @param [Fixnum] ttl 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def ttl(ttl=nil)
      if ttl.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:ttl, [Java::long.java_class]).call(ttl),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling ttl(#{ttl})"
    end
    # @param [true,false] first 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def first_acquirer(first=nil)
      if (first.class == TrueClass || first.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:firstAcquirer, [Java::boolean.java_class]).call(first),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling first_acquirer(#{first})"
    end
    # @param [Fixnum] count 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def delivery_count(count=nil)
      if count.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deliveryCount, [Java::int.java_class]).call(count),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling delivery_count(#{count})"
    end
    # @param [String] id 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def id(id=nil)
      if id.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:id, [Java::java.lang.String.java_class]).call(id),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling id(#{id})"
    end
    # @param [String] address 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def address(address=nil)
      if address.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:address, [Java::java.lang.String.java_class]).call(address),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling address(#{address})"
    end
    # @param [String] replyTo 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def reply_to(replyTo=nil)
      if replyTo.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:replyTo, [Java::java.lang.String.java_class]).call(replyTo),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling reply_to(#{replyTo})"
    end
    # @param [String] correlationId 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def correlation_id(correlationId=nil)
      if correlationId.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:correlationId, [Java::java.lang.String.java_class]).call(correlationId),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling correlation_id(#{correlationId})"
    end
    # @param [String] value 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_body(value=nil)
      if value.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBody, [Java::java.lang.String.java_class]).call(value),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_body(#{value})"
    end
    # @param [String] value 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_symbol_as_body(value=nil)
      if value.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withSymbolAsBody, [Java::java.lang.String.java_class]).call(value),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_symbol_as_body(#{value})"
    end
    # @param [String] subject 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def subject(subject=nil)
      if subject.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:subject, [Java::java.lang.String.java_class]).call(subject),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling subject(#{subject})"
    end
    # @param [String] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def content_type(ct=nil)
      if ct.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:contentType, [Java::java.lang.String.java_class]).call(ct),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling content_type(#{ct})"
    end
    # @param [String] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def content_encoding(ct=nil)
      if ct.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:contentEncoding, [Java::java.lang.String.java_class]).call(ct),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling content_encoding(#{ct})"
    end
    # @param [Fixnum] expiry 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def expiry_time(expiry=nil)
      if expiry.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:expiryTime, [Java::long.java_class]).call(expiry),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling expiry_time(#{expiry})"
    end
    # @param [Fixnum] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def creation_time(ct=nil)
      if ct.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:creationTime, [Java::long.java_class]).call(ct),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling creation_time(#{ct})"
    end
    # @param [String] gi 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def group_id(gi=nil)
      if gi.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:groupId, [Java::java.lang.String.java_class]).call(gi),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling group_id(#{gi})"
    end
    # @param [String] rt 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def reply_to_group_id(rt=nil)
      if rt.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:replyToGroupId, [Java::java.lang.String.java_class]).call(rt),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling reply_to_group_id(#{rt})"
    end
    # @param [Hash{String => Object}] props 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def application_properties(props=nil)
      if props.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:applicationProperties, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(props)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling application_properties(#{props})"
    end
    # @param [true,false] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_boolean_as_body(v=nil)
      if (v.class == TrueClass || v.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBooleanAsBody, [Java::boolean.java_class]).call(v),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_boolean_as_body(#{v})"
    end
    # @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_byte_as_body(v=nil)
      if v.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withByteAsBody, [Java::byte.java_class]).call(::Vertx::Util::Utils.to_byte(v)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_byte_as_body(#{v})"
    end
    # @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_short_as_body(v=nil)
      if v.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withShortAsBody, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(v)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_short_as_body(#{v})"
    end
    # @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_integer_as_body(v=nil)
      if v.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withIntegerAsBody, [Java::int.java_class]).call(v),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_integer_as_body(#{v})"
    end
    # @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_long_as_body(v=nil)
      if v.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withLongAsBody, [Java::long.java_class]).call(v),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_long_as_body(#{v})"
    end
    # @param [Float] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_float_as_body(v=nil)
      if v.class == Float && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withFloatAsBody, [Java::float.java_class]).call(::Vertx::Util::Utils.to_float(v)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_float_as_body(#{v})"
    end
    # @param [Float] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_double_as_body(v=nil)
      if v.class == Float && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withDoubleAsBody, [Java::double.java_class]).call(::Vertx::Util::Utils.to_double(v)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_double_as_body(#{v})"
    end
    # @param [Fixnum] c 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_char_as_body(c=nil)
      if c.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withCharAsBody, [Java::char.java_class]).call(::Vertx::Util::Utils.to_character(c)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_char_as_body(#{c})"
    end
    # @param [::Vertx::Buffer] buffer 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_buffer_as_body(buffer=nil)
      if buffer.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBufferAsBody, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(buffer.j_del),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_buffer_as_body(#{buffer})"
    end
    # @param [Hash{String => Object}] json 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_json_object_as_body(json=nil)
      if json.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withJsonObjectAsBody, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(json)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_json_object_as_body(#{json})"
    end
    # @param [Array<String,Object>] json 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_json_array_as_body(json=nil)
      if json.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withJsonArrayAsBody, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(json)),::VertxAmqpClient::AmqpMessageBuilder)
      end
      raise ArgumentError, "Invalid arguments when calling with_json_array_as_body(#{json})"
    end
  end
end
