require 'vertx/vertx'
require 'vertx-consul/watch_result'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.consul.Watch
module VertxConsul
  #  Watches are a way of specifying a view of data (e.g. list of nodes, KV pairs, health checks)
  #  which is monitored for updates. When an update is detected, an <code>Handler</code> with <code>AsyncResult</code> is invoked.
  #  As an example, you could watch the status of health checks and notify when a check is critical.
  class Watch
    # @private
    # @param j_del [::VertxConsul::Watch] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxConsul::Watch] the underlying java delegate
    def j_del
      @j_del
    end
    #  Creates <code>Watch</code> to monitoring a specific key in the KV store.
    #  This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
    # @param [String] key the key
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.key(key=nil,vertx=nil,options=nil)
      if key.class == String && vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:key, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(key,vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
      elsif key.class == String && vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:key, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(key,vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
      end
      raise ArgumentError, "Invalid arguments when calling key(#{key},#{vertx},#{options})"
    end
    #  Creates <code>Watch</code> to monitoring a prefix of keys in the KV store.
    #  This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
    # @param [String] keyPrefix the key
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.key_prefix(keyPrefix=nil,vertx=nil,options=nil)
      if keyPrefix.class == String && vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:keyPrefix, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(keyPrefix,vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
      elsif keyPrefix.class == String && vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:keyPrefix, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(keyPrefix,vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
      end
      raise ArgumentError, "Invalid arguments when calling key_prefix(#{keyPrefix},#{vertx},#{options})"
    end
    #  Creates <code>Watch</code> to monitoring the list of available services.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/catalog.html#catalog_services">/v1/catalog/services</a> API internally.
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.services(vertx=nil,options=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:services, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
      elsif vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:services, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
      end
      raise ArgumentError, "Invalid arguments when calling services(#{vertx},#{options})"
    end
    #  Creates <code>Watch</code> to monitoring the nodes providing the service.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/health.html#health_service">/v1/health/service/&lt;service&gt;</a> API internally.
    # @param [String] service the service name
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.service(service=nil,vertx=nil,options=nil)
      if service.class == String && vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:service, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(service,vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
      elsif service.class == String && vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:service, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(service,vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
      end
      raise ArgumentError, "Invalid arguments when calling service(#{service},#{vertx},#{options})"
    end
    #  Creates <code>Watch</code> to monitoring the custom user events.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/event.html#event_list">/v1/event/list</a> API internally.
    # @param [String] event the event name
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.events(event=nil,vertx=nil,options=nil)
      if event.class == String && vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:events, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(event,vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
      elsif event.class == String && vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:events, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(event,vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
      end
      raise ArgumentError, "Invalid arguments when calling events(#{event},#{vertx},#{options})"
    end
    #  Creates <code>Watch</code> to monitoring the list of available nodes.
    #  This maps to the <a href="https://www.consul.io/api/catalog.html#list-nodes">/v1/catalog/nodes</a> API internally.
    # @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @param [Hash] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.nodes(vertx=nil,options=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && options == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:nodes, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
      elsif vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:nodes, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(vertx.j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
      end
      raise ArgumentError, "Invalid arguments when calling nodes(#{vertx},#{options})"
    end
    #  Set the result handler. As data is changed, the handler will be called with the result.
    # @yield the result handler
    # @return [self]
    def set_handler
      if block_given?
        @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxConsul::WatchResult, nil)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_handler()"
    end
    #  Start this <code>Watch</code>
    # @return [self]
    def start
      if !block_given?
        @j_del.java_method(:start, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling start()"
    end
    #  Stop the watch and release its resources
    # @return [void]
    def stop
      if !block_given?
        return @j_del.java_method(:stop, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling stop()"
    end
  end
end
