require 'vertx-mysql-postgresql/async_sql_client'
require 'vertx/vertx'
require 'vertx-sql/sql_client'
require 'vertx-sql/sql_operations'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.asyncsql.MySQLClient
module VertxMysqlPostgresql
  #  Represents an asynchronous MySQL client
  class MySQLClient < ::VertxMysqlPostgresql::AsyncSQLClient
    # @private
    # @param j_del [::VertxMysqlPostgresql::MySQLClient] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMysqlPostgresql::MySQLClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MySQLClient
    end
    def @@j_api_type.wrap(obj)
      MySQLClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAsyncsql::MySQLClient.java_class
    end
    #  Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
    #  getting a connection from the pool (this object) and return it back after the execution. Only the first result
    #  from the result set is returned.
    # @param [String] sql the statement to execute
    # @yield the result handler
    # @return [self]
    def query_single(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_single(#{sql})"
    end
    #  Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
    #  boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
    #  Only the first result from the result set is returned.
    # @param [String] sql the statement to execute
    # @param [Array<String,Object>] arguments the arguments
    # @yield the result handler
    # @return [self]
    def query_single_with_params(sql=nil,arguments=nil)
      if sql.class == String && arguments.class == Array && block_given?
        @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,::Vertx::Util::Utils.to_json_array(arguments),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_single_with_params(#{sql},#{arguments})"
    end
    #  Returns a connection that can be used to perform SQL operations on. It's important to remember
    #  to close the connection when you are done, so it is returned to the pool.
    # @yield the handler which is called when the <code>JdbcConnection</code> object is ready for use.
    # @return [self]
    def get_connection
      if block_given?
        @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLConnection) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    #  Close the client and release all resources.
    #  Call the handler when close is complete.
    # @yield the handler that will be called when close is complete
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
    #  statement and returns it back after the execution.
    # @param [String] sql the statement to execute
    # @yield the result handler
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    # @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_stream(#{sql})"
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    # @param [Array<String,Object>] params these are the parameters to fill the statement.
    # @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream_with_params(sql=nil,params=nil)
      if sql.class == String && params.class == Array && block_given?
        @j_del.java_method(:queryStreamWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,::Vertx::Util::Utils.to_json_array(params),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_stream_with_params(#{sql},#{params})"
    end
    #  Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
    #  prepared statement and returns it back after the execution.
    # @param [String] sql the statement to execute
    # @param [Array<String,Object>] arguments the arguments to the statement
    # @yield the result handler
    # @return [self]
    def query_with_params(sql=nil,arguments=nil)
      if sql.class == String && arguments.class == Array && block_given?
        @j_del.java_method(:queryWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,::Vertx::Util::Utils.to_json_array(arguments),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_with_params(#{sql},#{arguments})"
    end
    #  Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement.
    # @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    # @yield the handler which is called once the operation completes.
    # @return [self]
    def update(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update(#{sql})"
    end
    #  Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement with the given parameters
    # @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    # @param [Array<String,Object>] params these are the parameters to fill the statement.
    # @yield the handler which is called once the operation completes.
    # @return [self]
    def update_with_params(sql=nil,params=nil)
      if sql.class == String && params.class == Array && block_given?
        @j_del.java_method(:updateWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,::Vertx::Util::Utils.to_json_array(params),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update_with_params(#{sql},#{params})"
    end
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # @param [String] sql the SQL to execute. For example <code>{call getEmpName}</code>.
    # @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:call, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling call(#{sql})"
    end
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # 
    #  The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
    #  takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
    # 
    #  <pre>
    #    params = [VALUE1, VALUE2, null]
    #    outputs = [null, null, "VARCHAR"]
    #  </pre>
    # @param [String] sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
    # @param [Array<String,Object>] params these are the parameters to fill the statement.
    # @param [Array<String,Object>] outputs these are the outputs to fill the statement.
    # @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call_with_params(sql=nil,params=nil,outputs=nil)
      if sql.class == String && params.class == Array && outputs.class == Array && block_given?
        @j_del.java_method(:callWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,::Vertx::Util::Utils.to_json_array(params),::Vertx::Util::Utils.to_json_array(outputs),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling call_with_params(#{sql},#{params},#{outputs})"
    end
    #  Create a MySQL client which maintains its own pool.
    # @param [::Vertx::Vertx] vertx the Vert.x instance
    # @param [Hash{String => Object}] config the configuration
    # @return [::VertxMysqlPostgresql::AsyncSQLClient] the client
    def self.create_non_shared(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAsyncsql::MySQLClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config)),::VertxMysqlPostgresql::AsyncSQLClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_non_shared(#{vertx},#{config})"
    end
    #  Create a MySQL client which shares its data source with any other MySQL clients created with the same
    #  data source name
    # @param [::Vertx::Vertx] vertx the Vert.x instance
    # @param [Hash{String => Object}] config the configuration
    # @param [String] poolName the pool name
    # @return [::VertxMysqlPostgresql::AsyncSQLClient] the client
    def self.create_shared(vertx=nil,config=nil,poolName=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given? && poolName == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAsyncsql::MySQLClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config)),::VertxMysqlPostgresql::AsyncSQLClient)
      elsif vertx.class.method_defined?(:j_del) && config.class == Hash && poolName.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAsyncsql::MySQLClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config),poolName),::VertxMysqlPostgresql::AsyncSQLClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_shared(#{vertx},#{config},#{poolName})"
    end
    #  The default name used for the MySQL pool.
    def self.DEFAULT_POOL_NAME
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_POOL_NAME
    end
    #  The default host.
    def self.DEFAULT_HOST
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_HOST
    end
    #  The default port.
    def self.DEFAULT_PORT
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_PORT
    end
    #  The default database.
    def self.DEFAULT_DATABASE
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_DATABASE
    end
    #  The default database user.
    def self.DEFAULT_USER
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_USER
    end
    #  The default database password.
    def self.DEFAULT_PASSWORD
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_PASSWORD
    end
    #  The default charset.
    def self.DEFAULT_CHARSET
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_CHARSET
    end
    #  The default timeout for connect.
    def self.DEFAULT_CONNECT_TIMEOUT
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_CONNECT_TIMEOUT
    end
    #  The default timeout for tests.
    def self.DEFAULT_TEST_TIMEOUT
      Java::IoVertxExtAsyncsql::MySQLClient.DEFAULT_TEST_TIMEOUT
    end
  end
end
