require 'vertx-web-client/http_response'
require 'vertx-web-client/error_converter'
require 'vertx-web-client/response_predicate_result'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.predicate.ResponsePredicate
module VertxWebClient
  #  A predicate on .
  #  <p>
  #  By default, a Vert.x Web Client request ends with an error only if something wrong happens at the network level.
  #  In other words, a <code>404 Not Found</code> response, or a response with the wrong content type, are <em>NOT</em> considered as failures.
  #  <p>
  #  {::VertxWebClient::ResponsePredicateResponse predicates} can fail a request when the response does not match some criteria.
  #  <p>
  #  Custom predicate instances can be used with .
  #  <p>
  #  As a convenience, a few predicates for common uses cases are predefined. For example:
  #  <ul>
  #  <li>SC_SUCCESS to verify that the response has a <code>2xx</code> code, or</li>
  #  <li>JSON to verify that the response body contains JSON data.</li>
  #  <li>...</li>
  #  </ul>
  #  Predefined predicates use the default error converter (discarding the body).
  #  <p>
  #  However, you can create a new {::VertxWebClient::ResponsePredicate} instance from an existing one using {::VertxWebClient::ResponsePredicate#create} or
  #  {::VertxWebClient::ResponsePredicate#create} when the body is required to build the validation failure.
  class ResponsePredicate
    # @private
    # @param j_del [::VertxWebClient::ResponsePredicate] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebClient::ResponsePredicate] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ResponsePredicate
    end
    def @@j_api_type.wrap(obj)
      ResponsePredicate.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_class
    end
    #  Creates a predicate asserting that the status response code is in the <code>[min,max[</code> range.
    # @param [Fixnum] min the lower (inclusive) accepted status code
    # @param [Fixnum] max the highest (exclusive) accepted status code
    # @return [::VertxWebClient::ResponsePredicate]
    def self.status(min=nil,max=nil)
      if min.class == Fixnum && !block_given? && max == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:status, [Java::int.java_class]).call(min),::VertxWebClient::ResponsePredicate)
      elsif min.class == Fixnum && max.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:status, [Java::int.java_class,Java::int.java_class]).call(min,max),::VertxWebClient::ResponsePredicate)
      end
      raise ArgumentError, "Invalid arguments when calling status(#{min},#{max})"
    end
    #  Creates a predicate validating the response has a <code>content-type</code> header matching one of the <code>mimeTypes</code>.
    # @overload contentType(mimeType)
    #   @param [String] mimeType the mime type
    # @overload contentType(mimeTypes)
    #   @param [Array<String>] mimeTypes the list of mime types
    # @return [::VertxWebClient::ResponsePredicate]
    def self.content_type(param_1=nil)
      if param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:contentType, [Java::java.lang.String.java_class]).call(param_1),::VertxWebClient::ResponsePredicate)
      elsif param_1.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:contentType, [Java::JavaUtil::List.java_class]).call(param_1.map { |element| element }),::VertxWebClient::ResponsePredicate)
      end
      raise ArgumentError, "Invalid arguments when calling content_type(#{param_1})"
    end
    #  Creates a new {::VertxWebClient::ResponsePredicate}, using a custom <code>errorConverter</code>.
    # @param [Proc] test the function to invoke when the response is received
    # @param [::VertxWebClient::ErrorConverter] errorConverter converts the result of the <code>test</code> function to a Throwable
    # @return [::VertxWebClient::ResponsePredicate]
    def self.create(test=nil,errorConverter=nil)
      if block_given? && test == nil && errorConverter == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:create, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWebClient::HttpResponse, nil)).j_del })),::VertxWebClient::ResponsePredicate)
      elsif test.class == Proc && errorConverter.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.java_method(:create, [Java::JavaUtilFunction::Function.java_class,Java::IoVertxExtWebClientPredicate::ErrorConverter.java_class]).call((Proc.new { |event| test.call(::Vertx::Util::Utils.safe_create(event,::VertxWebClient::HttpResponse, nil)).j_del }),errorConverter.j_del),::VertxWebClient::ResponsePredicate)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{test},#{errorConverter})"
    end
    # @return [::VertxWebClient::ErrorConverter] the error converter currently used
    def error_converter
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:errorConverter, []).call(),::VertxWebClient::ErrorConverter)
      end
      raise ArgumentError, "Invalid arguments when calling error_converter()"
    end
    #  Any 1XX informational response
    def self.SC_INFORMATIONAL_RESPONSE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_INFORMATIONAL_RESPONSE,::VertxWebClient::ResponsePredicate)
    end
    #  100 Continue
    def self.SC_CONTINUE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_CONTINUE,::VertxWebClient::ResponsePredicate)
    end
    #  101 Switching Protocols
    def self.SC_SWITCHING_PROTOCOLS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_SWITCHING_PROTOCOLS,::VertxWebClient::ResponsePredicate)
    end
    #  102 Processing (WebDAV, RFC2518)
    def self.SC_PROCESSING
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PROCESSING,::VertxWebClient::ResponsePredicate)
    end
    #  103 Early Hints
    def self.SC_EARLY_HINTS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_EARLY_HINTS,::VertxWebClient::ResponsePredicate)
    end
    #  Any 2XX success
    def self.SC_SUCCESS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_SUCCESS,::VertxWebClient::ResponsePredicate)
    end
    #  200 OK
    def self.SC_OK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_OK,::VertxWebClient::ResponsePredicate)
    end
    #  201 Created
    def self.SC_CREATED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_CREATED,::VertxWebClient::ResponsePredicate)
    end
    #  202 Accepted
    def self.SC_ACCEPTED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_ACCEPTED,::VertxWebClient::ResponsePredicate)
    end
    #  203 Non-Authoritative Information (since HTTP/1.1)
    def self.SC_NON_AUTHORITATIVE_INFORMATION
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NON_AUTHORITATIVE_INFORMATION,::VertxWebClient::ResponsePredicate)
    end
    #  204 No Content
    def self.SC_NO_CONTENT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NO_CONTENT,::VertxWebClient::ResponsePredicate)
    end
    #  205 Reset Content
    def self.SC_RESET_CONTENT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_RESET_CONTENT,::VertxWebClient::ResponsePredicate)
    end
    #  206 Partial Content
    def self.SC_PARTIAL_CONTENT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PARTIAL_CONTENT,::VertxWebClient::ResponsePredicate)
    end
    #  207 Multi-Status (WebDAV, RFC2518)
    def self.SC_MULTI_STATUS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_MULTI_STATUS,::VertxWebClient::ResponsePredicate)
    end
    #  Any 3XX redirection
    def self.SC_REDIRECTION
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REDIRECTION,::VertxWebClient::ResponsePredicate)
    end
    #  300 Multiple Choices
    def self.SC_MULTIPLE_CHOICES
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_MULTIPLE_CHOICES,::VertxWebClient::ResponsePredicate)
    end
    #  301 Moved Permanently
    def self.SC_MOVED_PERMANENTLY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_MOVED_PERMANENTLY,::VertxWebClient::ResponsePredicate)
    end
    #  302 Found
    def self.SC_FOUND
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_FOUND,::VertxWebClient::ResponsePredicate)
    end
    #  303 See Other (since HTTP/1.1)
    def self.SC_SEE_OTHER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_SEE_OTHER,::VertxWebClient::ResponsePredicate)
    end
    #  304 Not Modified
    def self.SC_NOT_MODIFIED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NOT_MODIFIED,::VertxWebClient::ResponsePredicate)
    end
    #  305 Use Proxy (since HTTP/1.1)
    def self.SC_USE_PROXY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_USE_PROXY,::VertxWebClient::ResponsePredicate)
    end
    #  307 Temporary Redirect (since HTTP/1.1)
    def self.SC_TEMPORARY_REDIRECT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_TEMPORARY_REDIRECT,::VertxWebClient::ResponsePredicate)
    end
    #  308 Permanent Redirect (RFC7538)
    def self.SC_PERMANENT_REDIRECT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PERMANENT_REDIRECT,::VertxWebClient::ResponsePredicate)
    end
    #  Any 4XX client error
    def self.SC_CLIENT_ERRORS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_CLIENT_ERRORS,::VertxWebClient::ResponsePredicate)
    end
    #  400 Bad Request
    def self.SC_BAD_REQUEST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_BAD_REQUEST,::VertxWebClient::ResponsePredicate)
    end
    #  401 Unauthorized
    def self.SC_UNAUTHORIZED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_UNAUTHORIZED,::VertxWebClient::ResponsePredicate)
    end
    #  402 Payment Required
    def self.SC_PAYMENT_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PAYMENT_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  403 Forbidden
    def self.SC_FORBIDDEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_FORBIDDEN,::VertxWebClient::ResponsePredicate)
    end
    #  404 Not Found
    def self.SC_NOT_FOUND
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NOT_FOUND,::VertxWebClient::ResponsePredicate)
    end
    #  405 Method Not Allowed
    def self.SC_METHOD_NOT_ALLOWED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_METHOD_NOT_ALLOWED,::VertxWebClient::ResponsePredicate)
    end
    #  406 Not Acceptable
    def self.SC_NOT_ACCEPTABLE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NOT_ACCEPTABLE,::VertxWebClient::ResponsePredicate)
    end
    #  407 Proxy Authentication Required
    def self.SC_PROXY_AUTHENTICATION_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PROXY_AUTHENTICATION_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  408 Request Timeout
    def self.SC_REQUEST_TIMEOUT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REQUEST_TIMEOUT,::VertxWebClient::ResponsePredicate)
    end
    #  409 Conflict
    def self.SC_CONFLICT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_CONFLICT,::VertxWebClient::ResponsePredicate)
    end
    #  410 Gone
    def self.SC_GONE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_GONE,::VertxWebClient::ResponsePredicate)
    end
    #  411 Length Required
    def self.SC_LENGTH_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_LENGTH_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  412 Precondition Failed
    def self.SC_PRECONDITION_FAILED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PRECONDITION_FAILED,::VertxWebClient::ResponsePredicate)
    end
    #  413 Request Entity Too Large
    def self.SC_REQUEST_ENTITY_TOO_LARGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REQUEST_ENTITY_TOO_LARGE,::VertxWebClient::ResponsePredicate)
    end
    #  414 Request-URI Too Long
    def self.SC_REQUEST_URI_TOO_LONG
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REQUEST_URI_TOO_LONG,::VertxWebClient::ResponsePredicate)
    end
    #  415 Unsupported Media Type
    def self.SC_UNSUPPORTED_MEDIA_TYPE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_UNSUPPORTED_MEDIA_TYPE,::VertxWebClient::ResponsePredicate)
    end
    #  416 Requested Range Not Satisfiable
    def self.SC_REQUESTED_RANGE_NOT_SATISFIABLE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REQUESTED_RANGE_NOT_SATISFIABLE,::VertxWebClient::ResponsePredicate)
    end
    #  417 Expectation Failed
    def self.SC_EXPECTATION_FAILED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_EXPECTATION_FAILED,::VertxWebClient::ResponsePredicate)
    end
    #  421 Misdirected Request
    def self.SC_MISDIRECTED_REQUEST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_MISDIRECTED_REQUEST,::VertxWebClient::ResponsePredicate)
    end
    #  422 Unprocessable Entity (WebDAV, RFC4918)
    def self.SC_UNPROCESSABLE_ENTITY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_UNPROCESSABLE_ENTITY,::VertxWebClient::ResponsePredicate)
    end
    #  423 Locked (WebDAV, RFC4918)
    def self.SC_LOCKED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_LOCKED,::VertxWebClient::ResponsePredicate)
    end
    #  424 Failed Dependency (WebDAV, RFC4918)
    def self.SC_FAILED_DEPENDENCY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_FAILED_DEPENDENCY,::VertxWebClient::ResponsePredicate)
    end
    #  425 Unordered Collection (WebDAV, RFC3648)
    def self.SC_UNORDERED_COLLECTION
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_UNORDERED_COLLECTION,::VertxWebClient::ResponsePredicate)
    end
    #  426 Upgrade Required (RFC2817)
    def self.SC_UPGRADE_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_UPGRADE_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  428 Precondition Required (RFC6585)
    def self.SC_PRECONDITION_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_PRECONDITION_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  429 Too Many Requests (RFC6585)
    def self.SC_TOO_MANY_REQUESTS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_TOO_MANY_REQUESTS,::VertxWebClient::ResponsePredicate)
    end
    #  431 Request Header Fields Too Large (RFC6585)
    def self.SC_REQUEST_HEADER_FIELDS_TOO_LARGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_REQUEST_HEADER_FIELDS_TOO_LARGE,::VertxWebClient::ResponsePredicate)
    end
    #  Any 5XX server error
    def self.SC_SERVER_ERRORS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_SERVER_ERRORS,::VertxWebClient::ResponsePredicate)
    end
    #  500 Internal Server Error
    def self.SC_INTERNAL_SERVER_ERROR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_INTERNAL_SERVER_ERROR,::VertxWebClient::ResponsePredicate)
    end
    #  501 Not Implemented
    def self.SC_NOT_IMPLEMENTED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NOT_IMPLEMENTED,::VertxWebClient::ResponsePredicate)
    end
    #  502 Bad Gateway
    def self.SC_BAD_GATEWAY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_BAD_GATEWAY,::VertxWebClient::ResponsePredicate)
    end
    #  503 Service Unavailable
    def self.SC_SERVICE_UNAVAILABLE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_SERVICE_UNAVAILABLE,::VertxWebClient::ResponsePredicate)
    end
    #  504 Gateway Timeout
    def self.SC_GATEWAY_TIMEOUT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_GATEWAY_TIMEOUT,::VertxWebClient::ResponsePredicate)
    end
    #  505 HTTP Version Not Supported
    def self.SC_HTTP_VERSION_NOT_SUPPORTED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_HTTP_VERSION_NOT_SUPPORTED,::VertxWebClient::ResponsePredicate)
    end
    #  506 Variant Also Negotiates (RFC2295)
    def self.SC_VARIANT_ALSO_NEGOTIATES
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_VARIANT_ALSO_NEGOTIATES,::VertxWebClient::ResponsePredicate)
    end
    #  507 Insufficient Storage (WebDAV, RFC4918)
    def self.SC_INSUFFICIENT_STORAGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_INSUFFICIENT_STORAGE,::VertxWebClient::ResponsePredicate)
    end
    #  510 Not Extended (RFC2774)
    def self.SC_NOT_EXTENDED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NOT_EXTENDED,::VertxWebClient::ResponsePredicate)
    end
    #  511 Network Authentication Required (RFC6585)
    def self.SC_NETWORK_AUTHENTICATION_REQUIRED
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.SC_NETWORK_AUTHENTICATION_REQUIRED,::VertxWebClient::ResponsePredicate)
    end
    #  Creates a predicate validating the response <code>content-type</code> is <code>application/json</code>.
    def self.JSON
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicate.JSON,::VertxWebClient::ResponsePredicate)
    end
  end
end
