require 'vertx/json_pointer_iterator'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.json.pointer.JsonPointer
module Vertx
  #  Implementation of <a href="https://tools.ietf.org/html/rfc6901">RFC6901 Json Pointers</a>.
  class JsonPointer
    # @private
    # @param j_del [::Vertx::JsonPointer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonPointer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonPointer
    end
    def @@j_api_type.wrap(obj)
      JsonPointer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreJsonPointer::JsonPointer.java_class
    end
    #  Return <code>true</code> if the pointer is a root pointer
    # @return [true,false]
    def root_pointer?
      if !block_given?
        return @j_del.java_method(:isRootPointer, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling root_pointer?()"
    end
    #  Return <code>true</code> if the pointer is local (URI with only fragment)
    # @return [true,false]
    def local_pointer?
      if !block_given?
        return @j_del.java_method(:isLocalPointer, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling local_pointer?()"
    end
    #  Return <code>true</code> if this pointer is a parent pointer of <code>child</code>.
    #  <br/>
    #  For instance <code>"/properties"</code> pointer is parent pointer of <code>"/properties/parent"</code>
    # @param [::Vertx::JsonPointer] child 
    # @return [true,false]
    def parent?(child=nil)
      if child.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:isParent, [Java::IoVertxCoreJsonPointer::JsonPointer.java_class]).call(child.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling parent?(#{child})"
    end
    #  Build a <a href="https://tools.ietf.org/html/rfc6901#section-5">string representation</a> of the JSON Pointer
    # @return [String]
    def to_string
      if !block_given?
        return @j_del.java_method(:toString, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling to_string()"
    end
    #  Append all tokens of <code>pointer</code> to this pointer <br/>
    #  Note: The base URI of this pointer will remain untouched
    # @overload append(token)
    #   @param [String] token the unescaped reference token
    # @overload append(index)
    #   @param [Fixnum] index 
    # @overload append(tokens)
    #   @param [Array<String>] tokens unescaped reference tokens
    # @overload append(pointer)
    #   @param [::Vertx::JsonPointer] pointer other pointer
    # @return [self]
    def append(param_1=nil)
      if param_1.class == String && !block_given?
        @j_del.java_method(:append, [Java::java.lang.String.java_class]).call(param_1)
        return self
      elsif param_1.class == Fixnum && !block_given?
        @j_del.java_method(:append, [Java::int.java_class]).call(param_1)
        return self
      elsif param_1.class == Array && !block_given?
        @j_del.java_method(:append, [Java::JavaUtil::List.java_class]).call(param_1.map { |element| element })
        return self
      elsif param_1.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:append, [Java::IoVertxCoreJsonPointer::JsonPointer.java_class]).call(param_1.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling append(#{param_1})"
    end
    #  Remove last reference token of this pointer
    # @return [self]
    def parent
      if !block_given?
        @j_del.java_method(:parent, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling parent()"
    end
    #  Query <code>objectToQuery</code> using the provided {::Vertx::JsonPointerIterator}. <br/>
    #  If you need to query Vert.x json data structures, use {::Vertx::JsonPointer#query_json}<br/>
    #  Note: if this pointer is a root pointer, this function returns the provided object
    # @param [Object] objectToQuery the object to query
    # @param [::Vertx::JsonPointerIterator] iterator the json pointer iterator that provides the logic to access to the objectToQuery
    # @return [Object] null if pointer points to not existing value, otherwise the requested value
    def query(objectToQuery=nil,iterator=nil)
      if ::Vertx::Util::unknown_type.accept?(objectToQuery) && iterator.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:query, [Java::java.lang.Object.java_class,Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class]).call(::Vertx::Util::Utils.to_object(objectToQuery),iterator.j_del))
      end
      raise ArgumentError, "Invalid arguments when calling query(#{objectToQuery},#{iterator})"
    end
    #  Query <code>objectToQuery</code> using the provided {::Vertx::JsonPointerIterator}. If the query result is null, returns the default. <br/>
    #  If you need to query Vert.x json data structures, use {::Vertx::JsonPointer#query_json_or_default}<br/>
    #  Note: if this pointer is a root pointer, this function returns the provided object
    # @param [Object] objectToQuery the object to query
    # @param [::Vertx::JsonPointerIterator] iterator the json pointer iterator that provides the logic to access to the objectToQuery
    # @param [Object] defaultValue default value if query result is null
    # @return [Object] null if pointer points to not existing value, otherwise the requested value
    def query_or_default(objectToQuery=nil,iterator=nil,defaultValue=nil)
      if ::Vertx::Util::unknown_type.accept?(objectToQuery) && iterator.class.method_defined?(:j_del) && ::Vertx::Util::unknown_type.accept?(defaultValue) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:queryOrDefault, [Java::java.lang.Object.java_class,Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(objectToQuery),iterator.j_del,::Vertx::Util::Utils.to_object(defaultValue)))
      end
      raise ArgumentError, "Invalid arguments when calling query_or_default(#{objectToQuery},#{iterator},#{defaultValue})"
    end
    #  Query <code>jsonElement</code>. <br/>
    #  Note: if this pointer is a root pointer, this function returns the provided json element
    # @param [Object] jsonElement the json element to query
    # @return [Object] null if pointer points to not existing value, otherwise the requested value
    def query_json(jsonElement=nil)
      if ::Vertx::Util::unknown_type.accept?(jsonElement) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:queryJson, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(jsonElement)))
      end
      raise ArgumentError, "Invalid arguments when calling query_json(#{jsonElement})"
    end
    #  Query <code>jsonElement</code>. If the query result is null, returns the default.<br/>
    #  Note: if this pointer is a root pointer, this function returns the provided object
    # @param [Object] jsonElement the json element to query
    # @param [Object] defaultValue default value if query result is null
    # @return [Object] null if pointer points to not existing value, otherwise the requested value
    def query_json_or_default(jsonElement=nil,defaultValue=nil)
      if ::Vertx::Util::unknown_type.accept?(jsonElement) && ::Vertx::Util::unknown_type.accept?(defaultValue) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:queryJsonOrDefault, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(jsonElement),::Vertx::Util::Utils.to_object(defaultValue)))
      end
      raise ArgumentError, "Invalid arguments when calling query_json_or_default(#{jsonElement},#{defaultValue})"
    end
    #  Query <code>objectToQuery</code> tracing each element walked during the query, including the first and the result (if any).<br/>
    #  The first element of the list is objectToQuery and the last is the result, or the element before the first null was encountered
    # @param [Object] objectToQuery the object to query
    # @param [::Vertx::JsonPointerIterator] iterator the json pointer iterator that provides the logic to access to the objectToQuery
    # @return [Array<Object>] the stream of walked elements
    def traced_query(objectToQuery=nil,iterator=nil)
      if ::Vertx::Util::unknown_type.accept?(objectToQuery) && iterator.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:tracedQuery, [Java::java.lang.Object.java_class,Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class]).call(::Vertx::Util::Utils.to_object(objectToQuery),iterator.j_del).to_a.map { |elt| ::Vertx::Util::Utils.from_object(elt) }
      end
      raise ArgumentError, "Invalid arguments when calling traced_query(#{objectToQuery},#{iterator})"
    end
    #  Write <code>newElement</code> in <code>objectToWrite</code> using this pointer. The path token "-" is handled as append to end of array <br/>
    #  If you need to write in Vert.x json data structures, use {::Vertx::JsonPointer#write_json} (Object)}<br/>
    # @param [Object] objectToWrite object to write
    # @param [::Vertx::JsonPointerIterator] iterator the json pointer iterator that provides the logic to access to the objectToMutate
    # @param [Object] newElement object to insert
    # @param [true,false] createOnMissing create objects when missing a object key or an array index
    # @return [Object] a reference to objectToWrite if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
    def write(objectToWrite=nil,iterator=nil,newElement=nil,createOnMissing=nil)
      if ::Vertx::Util::unknown_type.accept?(objectToWrite) && iterator.class.method_defined?(:j_del) && ::Vertx::Util::unknown_type.accept?(newElement) && (createOnMissing.class == TrueClass || createOnMissing.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:write, [Java::java.lang.Object.java_class,Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class,Java::java.lang.Object.java_class,Java::boolean.java_class]).call(::Vertx::Util::Utils.to_object(objectToWrite),iterator.j_del,::Vertx::Util::Utils.to_object(newElement),createOnMissing))
      end
      raise ArgumentError, "Invalid arguments when calling write(#{objectToWrite},#{iterator},#{newElement},#{createOnMissing})"
    end
    #  Write <code>newElement</code> in <code>jsonElement</code> using this pointer. The path token "-" is handled as append to end of array.
    # @param [Object] jsonElement json to query and write
    # @param [Object] newElement json to insert
    # @param [true,false] createOnMissing create JsonObject when missing a object key or an array index
    # @return [Object] a reference to json if the write was completed, a reference to newElement if the pointer is a root pointer, null if the write failed
    def write_json(jsonElement=nil,newElement=nil,createOnMissing=nil)
      if ::Vertx::Util::unknown_type.accept?(jsonElement) && ::Vertx::Util::unknown_type.accept?(newElement) && !block_given? && createOnMissing == nil
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:writeJson, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(jsonElement),::Vertx::Util::Utils.to_object(newElement)))
      elsif ::Vertx::Util::unknown_type.accept?(jsonElement) && ::Vertx::Util::unknown_type.accept?(newElement) && (createOnMissing.class == TrueClass || createOnMissing.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:writeJson, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::boolean.java_class]).call(::Vertx::Util::Utils.to_object(jsonElement),::Vertx::Util::Utils.to_object(newElement),createOnMissing))
      end
      raise ArgumentError, "Invalid arguments when calling write_json(#{jsonElement},#{newElement},#{createOnMissing})"
    end
    #  Copy a JsonPointer
    # @return [::Vertx::JsonPointer] a copy of this pointer
    def copy
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:copy, []).call(),::Vertx::JsonPointer)
      end
      raise ArgumentError, "Invalid arguments when calling copy()"
    end
    #  Build an empty JsonPointer
    # @return [::Vertx::JsonPointer] a new empty JsonPointer
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreJsonPointer::JsonPointer.java_method(:create, []).call(),::Vertx::JsonPointer)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
    #  Build a JsonPointer from a json pointer string
    # @param [String] pointer the string representing a pointer
    # @return [::Vertx::JsonPointer] new instance of JsonPointer
    def self.from(pointer=nil)
      if pointer.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreJsonPointer::JsonPointer.java_method(:from, [Java::java.lang.String.java_class]).call(pointer),::Vertx::JsonPointer)
      end
      raise ArgumentError, "Invalid arguments when calling from(#{pointer})"
    end
  end
end
