require 'vertx-amqp-client/amqp_sender'
require 'vertx-amqp-client/amqp_receiver'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpConnection
module VertxAmqpClient
  #  Once connected to the broker or router, you get a connection. This connection is automatically opened.
  class AmqpConnection
    # @private
    # @param j_del [::VertxAmqpClient::AmqpConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpConnection
    end
    def @@j_api_type.wrap(obj)
      AmqpConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpConnection.java_class
    end
    #  Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
    #  using the {::VertxAmqpClient::AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
    #  reply address.
    # @overload createDynamicReceiver(completionHandler)
    #   @yield the completion handler, called when the receiver has been created and opened.
    # @return [self]
    def create_dynamic_receiver
      if true
        if (block_given?)
          @j_del.java_method(:createDynamicReceiver, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createDynamicReceiver, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpReceiver.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_dynamic_receiver()"
      end
    end
    #  Creates a receiver used to consumer messages from the given address.
    # @overload createReceiver(address,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @yield the handler called with the receiver. The receiver has been opened.
    # @overload createReceiver(address,receiverOptions,completionHandler)
    #   @param [String] address The source address to attach the consumer to.
    #   @param [Hash{String => Object}] receiverOptions The options for this receiver.
    #   @yield The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @return [self]
    def create_receiver(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpReceiver.j_api_type)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpReceiver.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_receiver(#{args[0]},#{args[1]})"
      end
    end
    #  Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
    #  {::VertxAmqpClient::AmqpConnection#create_anonymous_sender}.
    # @overload createSender(address,completionHandler)
    #   @param [String] address The target address to attach to, must not be <code>null</code>
    #   @yield The handler called with the sender, once opened
    # @overload createSender(address,options,completionHandler)
    #   @param [String] address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
    #   @param [Hash{String => Object}] options The AMQP sender options
    #   @yield The handler called with the sender, once opened
    # @return [self]
    def create_sender(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpSender.j_api_type)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpSender.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_sender(#{args[0]},#{args[1]})"
      end
    end
    #  Closes the AMQP connection, i.e. allows the Close frame to be emitted.
    # @overload close(done)
    #   @yield the close handler notified when the connection is closed. May be <code>null</code>.
    # @return [self]
    def close
      if true
        if (block_given?)
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Registers a handler called on disconnection.
    # @overload exceptionHandler(handler)
    #   @yield the exception handler.
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Creates an anonymous sender.
    #  <p>
    #  Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
    #  an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
    #  but you don't know the address, as the reply address is passed into the message you are going to receive.
    # @overload createAnonymousSender(completionHandler)
    #   @yield The handler called with the created sender, once opened
    # @return [self]
    def create_anonymous_sender
      if true
        if (block_given?)
          @j_del.java_method(:createAnonymousSender, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createAnonymousSender, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpSender.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_anonymous_sender()"
      end
    end
  end
end
