require 'vertx-amqp-client/amqp_message'
require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpMessageBuilder
module VertxAmqpClient
  #  Builder to create a new {::VertxAmqpClient::AmqpMessage}.
  #  <p>
  #  Reference about the different metadata can be found on
  #  <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
  #  <p>
  #  Note that the body is set using <code>withBodyAs*</code> method depending on the passed type.
  class AmqpMessageBuilder
    # @private
    # @param j_del [::VertxAmqpClient::AmqpMessageBuilder] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpMessageBuilder] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpMessageBuilder
    end
    def @@j_api_type.wrap(obj)
      AmqpMessageBuilder.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpMessageBuilder.java_class
    end
    # @overload withByteAsBody(v)
    #   @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_byte_as_body(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withByteAsBody, [Java::byte.java_class]).call(::Vertx::Util::Utils.to_byte(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_byte_as_body(#{args[0]})"
      end
    end
    # @overload withSymbolAsBody(value)
    #   @param [String] value 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_symbol_as_body(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withSymbolAsBody, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_symbol_as_body(#{args[0]})"
      end
    end
    # @overload creationTime(ct)
    #   @param [Fixnum] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def creation_time(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:creationTime, [Java::long.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling creation_time(#{args[0]})"
      end
    end
    # @overload withJsonArrayAsBody(json)
    #   @param [Array<String,Object>] json 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_json_array_as_body(*args)
      if args[0].class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withJsonArrayAsBody, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_json_array_as_body(#{args[0]})"
      end
    end
    # @overload subject(subject)
    #   @param [String] subject 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def subject(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:subject, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subject(#{args[0]})"
      end
    end
    # @overload groupId(gi)
    #   @param [String] gi 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def group_id(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:groupId, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling group_id(#{args[0]})"
      end
    end
    # @overload withShortAsBody(v)
    #   @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_short_as_body(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withShortAsBody, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_short_as_body(#{args[0]})"
      end
    end
    # @overload withLongAsBody(v)
    #   @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_long_as_body(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withLongAsBody, [Java::long.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_long_as_body(#{args[0]})"
      end
    end
    # @overload withIntegerAsBody(v)
    #   @param [Fixnum] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_integer_as_body(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withIntegerAsBody, [Java::int.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_integer_as_body(#{args[0]})"
      end
    end
    # @overload durable(durable)
    #   @param [true,false] durable 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def durable(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:durable, [Java::boolean.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling durable(#{args[0]})"
      end
    end
    # @overload replyToGroupId(rt)
    #   @param [String] rt 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def reply_to_group_id(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:replyToGroupId, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_to_group_id(#{args[0]})"
      end
    end
    # @overload contentEncoding(ct)
    #   @param [String] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def content_encoding(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:contentEncoding, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_encoding(#{args[0]})"
      end
    end
    # @overload create()
    # @return [::VertxAmqpClient::AmqpMessageBuilder] a new instance of {::VertxAmqpClient::AmqpMessageBuilder}
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpMessageBuilder.java_method(:create, []).call(),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    # @overload applicationProperties(props)
    #   @param [Hash{String => Object}] props 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def application_properties(*args)
      if args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:applicationProperties, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling application_properties(#{args[0]})"
      end
    end
    # @overload correlationId(correlationId)
    #   @param [String] correlationId 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def correlation_id(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:correlationId, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling correlation_id(#{args[0]})"
      end
    end
    # @overload id(id)
    #   @param [String] id 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def id(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:id, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id(#{args[0]})"
      end
    end
    # @overload withDoubleAsBody(v)
    #   @param [Float] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_double_as_body(*args)
      if args[0].class == Float && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withDoubleAsBody, [Java::double.java_class]).call(::Vertx::Util::Utils.to_double(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_double_as_body(#{args[0]})"
      end
    end
    # @overload contentType(ct)
    #   @param [String] ct 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def content_type(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:contentType, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_type(#{args[0]})"
      end
    end
    # @overload deliveryCount(count)
    #   @param [Fixnum] count 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def delivery_count(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deliveryCount, [Java::int.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delivery_count(#{args[0]})"
      end
    end
    # @overload address(address)
    #   @param [String] address 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def address(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:address, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling address(#{args[0]})"
      end
    end
    # @overload withBufferAsBody(buffer)
    #   @param [::Vertx::Buffer] buffer 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_buffer_as_body(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBufferAsBody, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_buffer_as_body(#{args[0]})"
      end
    end
    # @overload withCharAsBody(c)
    #   @param [Fixnum] c 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_char_as_body(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withCharAsBody, [Java::char.java_class]).call(::Vertx::Util::Utils.to_character(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_char_as_body(#{args[0]})"
      end
    end
    # @overload priority(priority)
    #   @param [Fixnum] priority 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def priority(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:priority, [Java::short.java_class]).call(::Vertx::Util::Utils.to_short(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling priority(#{args[0]})"
      end
    end
    # @overload withBody(value)
    #   @param [String] value 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_body(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBody, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_body(#{args[0]})"
      end
    end
    # @overload ttl(ttl)
    #   @param [Fixnum] ttl 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def ttl(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:ttl, [Java::long.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ttl(#{args[0]})"
      end
    end
    # @overload withBooleanAsBody(v)
    #   @param [true,false] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_boolean_as_body(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withBooleanAsBody, [Java::boolean.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_boolean_as_body(#{args[0]})"
      end
    end
    # @overload build()
    # @return [::VertxAmqpClient::AmqpMessage] the message.
    def build
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:build, []).call(),::VertxAmqpClient::AmqpMessage)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling build()"
      end
    end
    # @overload withJsonObjectAsBody(json)
    #   @param [Hash{String => Object}] json 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_json_object_as_body(*args)
      if args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withJsonObjectAsBody, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_json_object_as_body(#{args[0]})"
      end
    end
    # @overload expiryTime(expiry)
    #   @param [Fixnum] expiry 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def expiry_time(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:expiryTime, [Java::long.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling expiry_time(#{args[0]})"
      end
    end
    # @overload replyTo(replyTo)
    #   @param [String] replyTo 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def reply_to(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:replyTo, [Java::java.lang.String.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_to(#{args[0]})"
      end
    end
    # @overload firstAcquirer(first)
    #   @param [true,false] first 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def first_acquirer(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:firstAcquirer, [Java::boolean.java_class]).call(args[0]),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling first_acquirer(#{args[0]})"
      end
    end
    # @overload withFloatAsBody(v)
    #   @param [Float] v 
    # @return [::VertxAmqpClient::AmqpMessageBuilder]
    def with_float_as_body(*args)
      if args[0].class == Float && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:withFloatAsBody, [Java::float.java_class]).call(::Vertx::Util::Utils.to_float(args[0])),::VertxAmqpClient::AmqpMessageBuilder)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling with_float_as_body(#{args[0]})"
      end
    end
  end
end
