require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.AuthStore
module VertxAuthCommon
  #  Generic interface to fetch user related information from a server backend.
  # 
  #  All methods of this interface are optional.
  class AuthStore
    # @private
    # @param j_del [::VertxAuthCommon::AuthStore] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::AuthStore] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AuthStore
    end
    def @@j_api_type.wrap(obj)
      AuthStore.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::AuthStore.java_class
    end
    #  Update the user credential.
    # @overload updateUserCredential(id,data,upsert,handler)
    #   @param [String] id the unique user identifier.
    #   @param [Hash{String => Object}] data the data to update.
    #   @param [true,false] upsert insert if not present.
    #   @yield the handler for the result callback.
    # @return [self]
    def update_user_credential(*args)
      if args[0].class == String && args[1].class == Hash && (args[2].class == TrueClass || args[2].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:updateUserCredential, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateUserCredential, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_user_credential(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Get the user permissions from the storage.
    # @overload getUserPermissions(id,handler)
    #   @param [String] id the unique user identifier.
    #   @yield the handler for the result callback.
    # @return [self]
    def get_user_permissions(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getUserPermissions, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getUserPermissions, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_user_permissions(#{args[0]})"
      end
    end
    #  Retrieves the user credentials from a backend given the user unique identifier.
    #  It may return more than 1 result, for example when a user can be identified using different modalities.
    # @overload getUserCredentialsById(rawId,handler)
    #   @param [String] rawId user unique rawId.
    #   @yield the handler for the result callback.
    # @return [self]
    def get_user_credentials_by_id(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getUserCredentialsById, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getUserCredentialsById, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_user_credentials_by_id(#{args[0]})"
      end
    end
    #  Generates a unique ID that doesn't contain any user identifiable information. By default it generates a random UUID.
    #  Although this is will work for most cases a better implementation that prevents collisions of IDs should be
    #  preferred.
    # @overload generateId()
    # @return [String] a new unique ID as a string
    def generate_id
      if !block_given?
        return @j_del.java_method(:generateId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling generate_id()"
      end
    end
    #  Get the user roles from the storage.
    # @overload getUserRoles(id,handler)
    #   @param [String] id the unique user identifier.
    #   @yield the handler for the result callback.
    # @return [self]
    def get_user_roles(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getUserRoles, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getUserRoles, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_user_roles(#{args[0]})"
      end
    end
    #  Retrieves the user credentials from a backend given the user unique identifier.
    #  It may return more than 1 result, for example when a user can be identified using different modalities.
    # @overload getUserCredentialsByName(username,handler)
    #   @param [String] username user unique name.
    #   @yield the handler for the result callback.
    # @return [self]
    def get_user_credentials_by_name(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:getUserCredentialsByName, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getUserCredentialsByName, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_user_credentials_by_name(#{args[0]})"
      end
    end
  end
end
