require 'vertx-auth-common/user'
require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.AuthorizationContext
module VertxAuthCommon
  #  The AuthorizationContext contains properties that can be used to match
  #  authorizations.
  class AuthorizationContext
    # @private
    # @param j_del [::VertxAuthCommon::AuthorizationContext] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::AuthorizationContext] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AuthorizationContext
    end
    def @@j_api_type.wrap(obj)
      AuthorizationContext.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::AuthorizationContext.java_class
    end
    # @overload variables()
    # @return [::Vertx::MultiMap] a Multimap containing variable names and values that can be resolved at runtime by {::VertxAuthCommon::Authorization}Authorizations
    def variables
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:variables, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling variables()"
      end
    end
    #  Factory for Authorization Context
    # @overload create(user)
    #   @param [::VertxAuthCommon::User] user a user
    # @return [::VertxAuthCommon::AuthorizationContext] a AuthorizationContext instance
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::AuthorizationContext.java_method(:create, [Java::IoVertxExtAuth::User.java_class]).call(args[0].j_del),::VertxAuthCommon::AuthorizationContext)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Get the authenticated user
    # @overload user()
    # @return [::VertxAuthCommon::User] the user
    def user
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:user, []).call(),::VertxAuthCommon::User)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling user()"
      end
    end
  end
end
