require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.Authorizations
module VertxAuthCommon
  class Authorizations
    # @private
    # @param j_del [::VertxAuthCommon::Authorizations] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::Authorizations] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Authorizations
    end
    def @@j_api_type.wrap(obj)
      Authorizations.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::Authorizations.java_class
    end
    # @overload add(providerId,authorizations)
    #   @param [String] providerId 
    #   @param [Set<::VertxAuthCommon::Authorization>] authorizations 
    # @overload add(providerId,authorization)
    #   @param [String] providerId 
    #   @param [::VertxAuthCommon::Authorization] authorization 
    # @return [self]
    def add(*args)
      if args[0].class == String && args[1].class == Set && !block_given?
        @j_del.java_method(:add, [Java::java.lang.String.java_class,Java::JavaUtil::Set.java_class]).call(args[0],Java::JavaUtil::LinkedHashSet.new(args[1].map { |element| element.j_del }))
        return self
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:add, [Java::java.lang.String.java_class,Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0],args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add(#{args[0]},#{args[1]})"
      end
    end
    # @overload getProviderIds()
    # @return [Set<String>]
    def get_provider_ids
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:getProviderIds, []).call()).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_provider_ids()"
      end
    end
    # @overload get(providerId)
    #   @param [String] providerId 
    # @return [Set<::VertxAuthCommon::Authorization>]
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0])).map! { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxAuthCommon::Authorization) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    # @overload delete(providerId)
    #   @param [String] providerId 
    # @return [self]
    def delete(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:delete, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]})"
      end
    end
  end
end
