require 'vertx-auth-common/hashing_algorithm'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.HashingStrategy
module VertxAuthCommon
  #  Hashing Strategy manager.
  # 
  #  This class will load system provided hashing strategies and algorithms.
  class HashingStrategy
    # @private
    # @param j_del [::VertxAuthCommon::HashingStrategy] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::HashingStrategy] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HashingStrategy
    end
    def @@j_api_type.wrap(obj)
      HashingStrategy.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::HashingStrategy.java_class
    end
    #  Factory method to load the algorithms from the system
    # @overload load()
    # @return [::VertxAuthCommon::HashingStrategy] a Hashing Strategy capable of hashing using the available algorithms
    def self.load
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuth::HashingStrategy.java_method(:load, []).call(),::VertxAuthCommon::HashingStrategy)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling load()"
      end
    end
    #  Get an algorithm interface by its Id
    # @overload get(id)
    #   @param [String] id the algorithm id
    # @return [::VertxAuthCommon::HashingAlgorithm] the algorithm
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]),::VertxAuthCommon::HashingAlgorithm)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Time constant password check. Regardless of the check, this algorithm executes the same number of
    #  checks regardless of the correctly number of characters
    # @overload verify(hash,password)
    #   @param [String] hash the hash to verify
    #   @param [String] password the password to test against
    # @return [true,false] boolean
    def verify?(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        return @j_del.java_method(:verify, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling verify?(#{args[0]},#{args[1]})"
      end
    end
    #  Put or replace an algorithm into the list of system loaded algorithms.
    # @overload put(id,algorithm)
    #   @param [String] id the algorithm id
    #   @param [::VertxAuthCommon::HashingAlgorithm] algorithm the implementation
    # @return [self]
    def put(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:put, [Java::java.lang.String.java_class,Java::IoVertxExtAuth::HashingAlgorithm.java_class]).call(args[0],args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
    #  Hashes a password.
    # @overload hash(id,params,salt,password)
    #   @param [String] id the algorithm id
    #   @param [Hash{String => String}] params the algorithm specific paramters
    #   @param [String] salt the given salt
    #   @param [String] password the given password
    # @return [String] the hashed string
    def hash(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == String && args[3].class == String && !block_given?
        return @j_del.java_method(:hash, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],args[2],args[3])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling hash(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
  end
end
