require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.NotAuthorization
module VertxAuthCommon
  #  Allows to perform a logical 'not' of the specified authorization
  class NotAuthorization < ::VertxAuthCommon::Authorization
    # @private
    # @param j_del [::VertxAuthCommon::NotAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::NotAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == NotAuthorization
    end
    def @@j_api_type.wrap(obj)
      NotAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::NotAuthorization.java_class
    end
    # @overload create(authorization)
    #   @param [::VertxAuthCommon::Authorization] authorization 
    # @return [::VertxAuthCommon::NotAuthorization]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::NotAuthorization.java_method(:create, [Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0].j_del),::VertxAuthCommon::NotAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    # @overload getAuthorization()
    # @return [::VertxAuthCommon::Authorization]
    def get_authorization
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAuthorization, []).call(),::VertxAuthCommon::Authorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_authorization()"
      end
    end
  end
end
