require 'vertx/vertx'
require 'vertx-auth-common/authentication_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.htdigest.HtdigestAuth
module VertxAuthHtdigest
  #  An extension of AuthProvider which is using .htdigest file as store
  class HtdigestAuth < ::VertxAuthCommon::AuthenticationProvider
    # @private
    # @param j_del [::VertxAuthHtdigest::HtdigestAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthHtdigest::HtdigestAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HtdigestAuth
    end
    def @@j_api_type.wrap(obj)
      HtdigestAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_class
    end
    #  Creates an instance of HtdigestAuth by using the given htfile file.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload create(vertx,htfile)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] htfile the existing htfile.
    # @return [::VertxAuthHtdigest::HtdigestAuth] the created instance of {::VertxAuthHtdigest::HtdigestAuth}s
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxAuthHtdigest::HtdigestAuth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxAuthHtdigest::HtdigestAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Return the currently used realm
    # @overload realm()
    # @return [String] the realm
    def realm
      if !block_given?
        return @j_del.java_method(:realm, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling realm()"
      end
    end
    #  The property name to be used to set the name of the collection inside the config
    def self.HTDIGEST_FILE
      Java::IoVertxExtAuthHtdigest::HtdigestAuth.HTDIGEST_FILE
    end
  end
end
