require 'vertx-jdbc/jdbc_client'
require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jdbc.JDBCAuth
module VertxAuthJdbc
  #  Factory interface for creating {::VertxAuthCommon::AuthProvider} instances that use the Vert.x JDBC client.
  # 
  #  By default the hashing strategy is SHA-512. If you're already running in production this is backwards
  #  compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
  #  as it is the current OWASP recommendation for password storage.
  class JDBCAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthJdbc::JDBCAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJdbc::JDBCAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCAuth
    end
    def @@j_api_type.wrap(obj)
      JDBCAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJdbc::JDBCAuth.java_class
    end
    #  Set the permissions query to use. Use this if you want to override the default permissions query.
    # @overload setPermissionsQuery(permissionsQuery)
    #   @param [String] permissionsQuery the permissions query
    # @return [self]
    def set_permissions_query(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPermissionsQuery, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_permissions_query(#{args[0]})"
      end
    end
    #  Set the authentication query to use. Use this if you want to override the default authentication query.
    # @overload setAuthenticationQuery(authenticationQuery)
    #   @param [String] authenticationQuery the authentication query
    # @return [self]
    def set_authentication_query(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setAuthenticationQuery, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_authentication_query(#{args[0]})"
      end
    end
    #  Compute a salt string.
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @overload generateSalt()
    # @return [String] a non null salt value
    def generate_salt
      if !block_given?
        return @j_del.java_method(:generateSalt, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling generate_salt()"
      end
    end
    #  Provide a application configuration level on hash nonce's as a ordered list of
    #  nonces where each position corresponds to a version.
    # 
    #  The nonces are supposed not to be stored in the underlying jdbc storage but to
    #  be provided as a application configuration. The idea is to add one extra variable
    #  to the hash function in order to make breaking the passwords using rainbow tables
    #  or precomputed hashes harder. Leaving the attacker only with the brute force
    #  approach.
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @overload setNonces(nonces)
    #   @param [Array<String,Object>] nonces a List of non null Strings.
    # @return [self]
    def set_nonces(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:setNonces, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_nonces(#{args[0]})"
      end
    end
    #  Compute the hashed password given the unhashed password and the salt
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @overload computeHash(password,salt)
    #   @param [String] password the unhashed password
    #   @param [String] salt the salt
    # @overload computeHash(password,salt,version)
    #   @param [String] password the unhashed password
    #   @param [String] salt the salt
    #   @param [Fixnum] version the nonce version to use
    # @return [String] the hashed password
    def compute_hash(*args)
      if args[0].class == String && args[1].class == String && !block_given? && args[2] == nil
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
      elsif args[0].class == String && args[1].class == String && args[2].class == Fixnum && !block_given?
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class]).call(args[0],args[1],args[2])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling compute_hash(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Set the role prefix to distinguish from permissions when checking for isPermitted requests.
    # @overload setRolePrefix(rolePrefix)
    #   @param [String] rolePrefix a Prefix e.g.: "role:"
    # @return [self]
    def set_role_prefix(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setRolePrefix, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_role_prefix(#{args[0]})"
      end
    end
    #  Create a JDBC auth provider implementation
    # @overload create(vertx,client)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [::VertxJdbc::JDBCClient] client the JDBC client instance
    # @return [::VertxAuthJdbc::JDBCAuth] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtJdbc::JDBCClient.java_class]).call(args[0].j_del,args[1].j_del),::VertxAuthJdbc::JDBCAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Set the roles query to use. Use this if you want to override the default roles query.
    # @overload setRolesQuery(rolesQuery)
    #   @param [String] rolesQuery the roles query
    # @return [self]
    def set_roles_query(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setRolesQuery, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_roles_query(#{args[0]})"
      end
    end
    #  The default query to be used for authentication
    def self.DEFAULT_AUTHENTICATE_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_AUTHENTICATE_QUERY
    end
    #  The default query to retrieve all roles for the user
    def self.DEFAULT_ROLES_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_ROLES_QUERY
    end
    #  The default query to retrieve all permissions for the role
    def self.DEFAULT_PERMISSIONS_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_PERMISSIONS_QUERY
    end
    #  The default role prefix
    def self.DEFAULT_ROLE_PREFIX
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_ROLE_PREFIX
    end
  end
end
