require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jwt.authorization.JWTAuthorization
module VertxAuthJwt
  #  Implementation of the JWT authorization provider.
  class JWTAuthorization < ::VertxAuthCommon::AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthJwt::JWTAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJwt::JWTAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JWTAuthorization
    end
    def @@j_api_type.wrap(obj)
      JWTAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJwtAuthorization::JWTAuthorization.java_class
    end
    #  Factory method to create a Authorization provider for JWT tokens.
    # @overload create(rootClaim)
    #   @param [String] rootClaim slash separated string to the json array with the claims.
    # @return [::VertxAuthJwt::JWTAuthorization] a AuthorizationProvider
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJwtAuthorization::JWTAuthorization.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxAuthJwt::JWTAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
  end
end
