require 'vertx-mongo/mongo_client'
require 'vertx-auth-mongo/hash_strategy'
require 'vertx/future'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.mongo.MongoAuth
module VertxAuthMongo
  #  An extension of AuthProvider which is using  as store
  class MongoAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthMongo::MongoAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthMongo::MongoAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MongoAuth
    end
    def @@j_api_type.wrap(obj)
      MongoAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthMongo::MongoAuth.java_class
    end
    #  The HashStrategy which is used by the current instance
    # @overload setHashStrategy(hashStrategy)
    #   @param [::VertxAuthMongo::HashStrategy] hashStrategy the {::VertxAuthMongo::HashStrategy} to be set
    # @return [self]
    def set_hash_strategy(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setHashStrategy, [Java::IoVertxExtAuthMongo::HashStrategy.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_hash_strategy(#{args[0]})"
      end
    end
    #  Get the name of the field to be used for the roles. Defaults to DEFAULT_ROLE_FIELD. Roles are expected to
    #  be saved as JsonArray
    # @overload getRoleField()
    # @return [String] the roleField
    def get_role_field
      if !block_given?
        return @j_del.java_method(:getRoleField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_role_field()"
      end
    end
    #  Set the name of the field to be used for the roles. Defaults to DEFAULT_ROLE_FIELD. Roles are expected to
    #  be saved as JsonArray
    # @overload setRoleField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_role_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setRoleField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_role_field(#{args[0]})"
      end
    end
    #  The name of the collection used to store User objects inside. Defaults to DEFAULT_COLLECTION_NAME
    # @overload getCollectionName()
    # @return [String] the collectionName
    def get_collection_name
      if !block_given?
        return @j_del.java_method(:getCollectionName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_collection_name()"
      end
    end
    #  Get the name of the field to be used for the permissions. Defaults to DEFAULT_PERMISSION_FIELD.
    #  Permissions are expected to be saved as JsonArray
    # @overload getPermissionField()
    # @return [String] the permissionField
    def get_permission_field
      if !block_given?
        return @j_del.java_method(:getPermissionField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_permission_field()"
      end
    end
    #  Set the name of the field to be used for the permissions. Defaults to DEFAULT_PERMISSION_FIELD.
    #  Permissions are expected to be saved as JsonArray
    # @overload setPermissionField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_permission_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPermissionField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_permission_field(#{args[0]})"
      end
    end
    #  Set the name of the field to be used for the password Defaults to DEFAULT_PASSWORD_FIELD
    # @overload setPasswordField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_password_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPasswordField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_password_field(#{args[0]})"
      end
    end
    #  The Hash Algorithm which is used by the current instance
    # @overload setHashAlgorithm(hashAlgorithm)
    #   @param [:SHA512,:PBKDF2] hashAlgorithm the HashAlgorithm to be set
    # @return [self]
    def set_hash_algorithm(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:setHashAlgorithm, [Java::IoVertxExtAuthMongo::HashAlgorithm.java_class]).call(Java::IoVertxExtAuthMongo::HashAlgorithm.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_hash_algorithm(#{args[0]})"
      end
    end
    #  Set the name of the field to be used as property for the password of credentials in the method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}. Defaults to DEFAULT_CREDENTIAL_PASSWORD_FIELD
    # @overload setPasswordCredentialField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_password_credential_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPasswordCredentialField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_password_credential_field(#{args[0]})"
      end
    end
    #  Get the name of the field to be used for the password Defaults to DEFAULT_PASSWORD_FIELD
    # @overload getPasswordField()
    # @return [String] the passwordField
    def get_password_field
      if !block_given?
        return @j_del.java_method(:getPasswordField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_password_field()"
      end
    end
    #  The HashStrategy which is used by the current instance
    # @overload getHashStrategy()
    # @return [::VertxAuthMongo::HashStrategy] the defined instance of {::VertxAuthMongo::HashStrategy}
    def get_hash_strategy
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getHashStrategy, []).call(),::VertxAuthMongo::HashStrategy)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_hash_strategy()"
      end
    end
    #  Get the name of the field to be used for the username. Defaults to DEFAULT_USERNAME_FIELD
    # @overload getUsernameField()
    # @return [String] the usernameField
    def get_username_field
      if !block_given?
        return @j_del.java_method(:getUsernameField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_username_field()"
      end
    end
    #  Set the name of the field to be used for the salt. Only used when {::VertxAuthMongo::HashStrategy#set_salt_style} is
    #  set to 
    # @overload setSaltField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_salt_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setSaltField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_salt_field(#{args[0]})"
      end
    end
    #  Get the name of the field to be used as property for the password of credentials in the method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}. Defaults to DEFAULT_CREDENTIAL_PASSWORD_FIELD
    # @overload getPasswordCredentialField()
    # @return [String] the passwordCredentialField
    def get_password_credential_field
      if !block_given?
        return @j_del.java_method(:getPasswordCredentialField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_password_credential_field()"
      end
    end
    #  Get the name of the field to be used as property for the username in the method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}. Defaults to DEFAULT_CREDENTIAL_USERNAME_FIELD
    # @overload getUsernameCredentialField()
    # @return [String] the usernameCredentialField
    def get_username_credential_field
      if !block_given?
        return @j_del.java_method(:getUsernameCredentialField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_username_credential_field()"
      end
    end
    #  Get the name of the field to be used for the salt. Only used when {::VertxAuthMongo::HashStrategy#set_salt_style} is
    #  set to 
    # @overload getSaltField()
    # @return [String] the saltField
    def get_salt_field
      if !block_given?
        return @j_del.java_method(:getSaltField, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_salt_field()"
      end
    end
    #  Insert a new user into mongo in the convenient way
    # @overload insertUser(username,password,roles,permissions,resultHandler)
    #   @param [String] username the username to be set
    #   @param [String] password the passsword in clear text, will be adapted following the definitions of the defined {::VertxAuthMongo::HashStrategy}
    #   @param [Array<String>] roles a list of roles to be set
    #   @param [Array<String>] permissions a list of permissions to be set
    #   @yield the ResultHandler will be provided with the id of the generated record
    # @return [void]
    def insert_user(*args)
      if args[0].class == String && args[1].class == String && args[2].class == Array && args[3].class == Array && true
        if (block_given?)
          return @j_del.java_method(:insertUser, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].map { |element| element },args[3].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:insertUser, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].map { |element| element },args[3].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling insert_user(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Set the name of the field to be used for the username. Defaults to DEFAULT_USERNAME_FIELD
    # @overload setUsernameField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_username_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setUsernameField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_username_field(#{args[0]})"
      end
    end
    #  Creates an instance of MongoAuth by using the given  and configuration object. An example for a
    #  configuration object:
    # 
    #  <pre>
    #  JsonObject js = new JsonObject();
    #  js.put(MongoAuth.PROPERTY_COLLECTION_NAME, createCollectionName(MongoAuth.DEFAULT_COLLECTION_NAME));
    #  </pre>
    # @overload create(mongoClient,config)
    #   @param [::VertxMongo::MongoClient] mongoClient an instance of  to be used for data storage and retrival
    #   @param [Hash{String => Object}] config the configuration object for the current instance. By this
    # @return [::VertxAuthMongo::MongoAuth] the created instance of {::VertxAuthMongo::MongoAuth}s
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthMongo::MongoAuth.java_method(:create, [Java::IoVertxExtMongo::MongoClient.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxAuthMongo::MongoAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Set the name of the field to be used as property for the username in the method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}. Defaults to DEFAULT_CREDENTIAL_USERNAME_FIELD
    # @overload setUsernameCredentialField(fieldName)
    #   @param [String] fieldName the name of the field to be used
    # @return [self]
    def set_username_credential_field(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setUsernameCredentialField, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_username_credential_field(#{args[0]})"
      end
    end
    #  Set the name of the collection to be used. Defaults to DEFAULT_COLLECTION_NAME
    # @overload setCollectionName(collectionName)
    #   @param [String] collectionName the name of the collection to be used for storing and reading user data
    # @return [self]
    def set_collection_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setCollectionName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_collection_name(#{args[0]})"
      end
    end
    #  The property name to be used to set the name of the collection inside the config
    def self.PROPERTY_COLLECTION_NAME
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_COLLECTION_NAME
    end
    #  The property name to be used to set the name of the field, where the username is stored inside
    def self.PROPERTY_USERNAME_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_USERNAME_FIELD
    end
    #  The property name to be used to set the name of the field, where the roles are stored inside
    def self.PROPERTY_ROLE_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_ROLE_FIELD
    end
    #  The property name to be used to set the name of the field, where the permissions are stored inside
    def self.PROPERTY_PERMISSION_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_PERMISSION_FIELD
    end
    #  The property name to be used to set the name of the field, where the password is stored inside
    def self.PROPERTY_PASSWORD_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_PASSWORD_FIELD
    end
    #  The property name to be used to set the name of the field, where the username for the credentials is stored inside
    def self.PROPERTY_CREDENTIAL_USERNAME_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_CREDENTIAL_USERNAME_FIELD
    end
    #  The property name to be used to set the name of the field, where the password for the credentials is stored inside
    def self.PROPERTY_CREDENTIAL_PASSWORD_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_CREDENTIAL_PASSWORD_FIELD
    end
    #  The property name to be used to set the name of the field, where the SALT is stored inside
    def self.PROPERTY_SALT_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_SALT_FIELD
    end
    #  The property name to be used to set the name of the field, where the salt style is stored inside
    def self.PROPERTY_SALT_STYLE
      Java::IoVertxExtAuthMongo::MongoAuth.PROPERTY_SALT_STYLE
    end
    #  The default name of the collection to be used
    def self.DEFAULT_COLLECTION_NAME
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_COLLECTION_NAME
    end
    #  The default name of the property for the username, like it is stored in mongodb
    def self.DEFAULT_USERNAME_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_USERNAME_FIELD
    end
    #  The default name of the property for the password, like it is stored in mongodb
    def self.DEFAULT_PASSWORD_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_PASSWORD_FIELD
    end
    #  The default name of the property for the roles, like it is stored in mongodb. Roles are expected to be saved as
    #  JsonArray
    def self.DEFAULT_ROLE_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_ROLE_FIELD
    end
    #  The default name of the property for the permissions, like it is stored in mongodb. Permissions are expected to be
    #  saved as JsonArray
    def self.DEFAULT_PERMISSION_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_PERMISSION_FIELD
    end
    #  The default name of the property for the username, like it is transported in credentials by method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}
    def self.DEFAULT_CREDENTIAL_USERNAME_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_CREDENTIAL_USERNAME_FIELD
    end
    #  The default name of the property for the password, like it is transported in credentials by method
    #  {::VertxAuthCommon::AuthenticationProvider#authenticate}
    def self.DEFAULT_CREDENTIAL_PASSWORD_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_CREDENTIAL_PASSWORD_FIELD
    end
    #  The default name of the property for the salt field
    def self.DEFAULT_SALT_FIELD
      Java::IoVertxExtAuthMongo::MongoAuth.DEFAULT_SALT_FIELD
    end
    #  The prefix which is used by the method  when checking for role access
    def self.ROLE_PREFIX
      Java::IoVertxExtAuthMongo::MongoAuth.ROLE_PREFIX
    end
  end
end
