require 'vertx-auth-common/user'
require 'vertx/buffer'
require 'vertx-auth-oauth2/o_auth2_response'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.AccessToken
module VertxAuthOauth2
  #  AccessToken extension to the User interface
  class AccessToken < ::VertxAuthCommon::User
    # @private
    # @param j_del [::VertxAuthOauth2::AccessToken] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::AccessToken] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AccessToken
    end
    def @@j_api_type.wrap(obj)
      AccessToken.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::AccessToken.java_class
    end
    #  Load the user info as per OIDC spec.
    # @overload userInfo(callback)
    #   @yield - The callback function returning the results.
    # @return [self]
    def user_info
      if true
        if (block_given?)
          @j_del.java_method(:userInfo, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:userInfo, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling user_info()"
      end
    end
    # @overload setTrustJWT(trust)
    #   @param [true,false] trust 
    # @return [self]
    def set_trust_jwt(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setTrustJWT, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_trust_jwt(#{args[0]})"
      end
    end
    #  Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
    # @overload introspect(callback)
    #   @yield - The callback function returning the results.
    # @overload introspect(tokenType,callback)
    #   @param [String] tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
    #   @yield - The callback function returning the results.
    # @return [self]
    def introspect(*args)
      if true && args[0] == nil
        if (block_given?)
          @j_del.java_method(:introspect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:introspect, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspect, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling introspect(#{args[0]})"
      end
    end
    #  Revoke access or refresh token
    # @overload revoke(token_type,callback)
    #   @param [String] token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
    #   @yield - The callback function returning the results.
    # @return [self]
    def revoke(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:revoke, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:revoke, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling revoke(#{args[0]})"
      end
    end
    #  Refresh the access token
    # @overload refresh(callback)
    #   @yield - The callback function returning the results.
    # @return [self]
    def refresh
      if true
        if (block_given?)
          @j_del.java_method(:refresh, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:refresh, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling refresh()"
      end
    end
    #  The RAW String if available for the Access Token
    # @overload opaqueAccessToken()
    # @return [String] String
    def opaque_access_token
      if !block_given?
        return @j_del.java_method(:opaqueAccessToken, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling opaque_access_token()"
      end
    end
    #  The RAW String if available for the Id Token
    # @overload opaqueIdToken()
    # @return [String] String
    def opaque_id_token
      if !block_given?
        return @j_del.java_method(:opaqueIdToken, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling opaque_id_token()"
      end
    end
    #  The Access Token if present parsed as a JsonObject
    # @overload accessToken()
    # @return [Hash{String => Object}] JSON
    def access_token
      if !block_given?
        if @cached_access_token != nil
          return @cached_access_token
        end
        return @cached_access_token = @j_del.java_method(:accessToken, []).call() != nil ? JSON.parse(@j_del.java_method(:accessToken, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling access_token()"
      end
    end
    #  Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
    #  available on all providers.
    # @overload logout(callback)
    #   @yield - The callback function returning the results.
    # @return [self]
    def logout
      if true
        if (block_given?)
          @j_del.java_method(:logout, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:logout, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling logout()"
      end
    end
    #  The RAW String if available for the Refresh Token
    # @overload opaqueRefreshToken()
    # @return [String] String
    def opaque_refresh_token
      if !block_given?
        return @j_del.java_method(:opaqueRefreshToken, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling opaque_refresh_token()"
      end
    end
    #  Fetches a JSON resource using this Access Token.
    # @overload fetch(resource,callback)
    #   @param [String] resource - the resource to fetch.
    #   @yield - The callback function returning the results.
    # @overload fetch(method,resource,headers,payload,callback)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method - the HTTP method to user.
    #   @param [String] resource - the resource to fetch.
    #   @param [Hash{String => Object}] headers - extra headers to pass to the request.
    #   @param [::Vertx::Buffer] payload - payload to send to the server.
    #   @yield - The callback function returning the results.
    # @return [self]
    def fetch(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil && args[3] == nil
        if (block_given?)
          @j_del.java_method(:fetch, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:fetch, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::OAuth2Response.j_api_type)
        end
      elsif args[0].class == Symbol && args[1].class == String && args[2].class == Hash && args[3].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:fetch, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],::Vertx::Util::Utils.to_json_object(args[2]),args[3].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:fetch, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1],::Vertx::Util::Utils.to_json_object(args[2]),args[3].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::OAuth2Response.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  The Id Token if present parsed as a JsonObject
    # @overload idToken()
    # @return [Hash{String => Object}] JSON
    def id_token
      if !block_given?
        if @cached_id_token != nil
          return @cached_id_token
        end
        return @cached_id_token = @j_del.java_method(:idToken, []).call() != nil ? JSON.parse(@j_del.java_method(:idToken, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id_token()"
      end
    end
    #  Check if the access token own the required scopes to access to the resource.
    # @overload isScopeGranted()
    # @return [true,false]
    def scope_granted?
      if !block_given?
        return @j_del.java_method(:isScopeGranted, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling scope_granted?()"
      end
    end
    # @overload tokenType()
    # @return [String]
    def token_type
      if !block_given?
        return @j_del.java_method(:tokenType, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling token_type()"
      end
    end
  end
end
