require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization
module VertxAuthOauth2
  #  Implementation of the Keycloak Authorization Provider.
  class KeycloakAuthorization < ::VertxAuthCommon::AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthOauth2::KeycloakAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::KeycloakAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KeycloakAuthorization
    end
    def @@j_api_type.wrap(obj)
      KeycloakAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Authorization::KeycloakAuthorization.java_class
    end
    #  Factory method to create an Authorization Provider for tokens adhering to the Keycloak token format.
    #  When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
    #  is expected to be the extracted from the user  under the key: <code>accessToken</code>.
    # @overload create()
    # @return [::VertxAuthOauth2::KeycloakAuthorization] a AuthorizationProvider
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Authorization::KeycloakAuthorization.java_method(:create, []).call(),::VertxAuthOauth2::KeycloakAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
  end
end
