require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.KeycloakHelper
module VertxAuthOauth2
  #  Helper class for processing Keycloak principal.
  class KeycloakHelper
    # @private
    # @param j_del [::VertxAuthOauth2::KeycloakHelper] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::KeycloakHelper] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KeycloakHelper
    end
    def @@j_api_type.wrap(obj)
      KeycloakHelper.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::KeycloakHelper.java_class
    end
    # @overload acr(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.acr(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:acr, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling acr(#{args[0]})"
      end
    end
    # @overload allowedOrigins(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [Set<String>]
    def self.allowed_origins(*args)
      if args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.to_set(Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:allowedOrigins, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling allowed_origins(#{args[0]})"
      end
    end
    # @overload sessionState(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.session_state(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:sessionState, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling session_state(#{args[0]})"
      end
    end
    # @overload preferredUsername(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.preferred_username(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:preferredUsername, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling preferred_username(#{args[0]})"
      end
    end
    # @overload nickName(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.nick_name(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:nickName, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling nick_name(#{args[0]})"
      end
    end
    # @overload name(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.name(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:name, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name(#{args[0]})"
      end
    end
    #  Get decoded `id_token` from the principal.
    # @overload idToken(principal)
    #   @param [Hash{String => Object}] principal user principal
    # @return [Hash{String => Object}] the id token
    def self.id_token(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:idToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])) != nil ? JSON.parse(Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:idToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])).encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id_token(#{args[0]})"
      end
    end
    #  Parse the token string with base64 decoder.
    #  This will only obtain the "payload" part of the token.
    # @overload parseToken(token)
    #   @param [String] token token string
    # @return [Hash{String => Object}] token payload json object
    def self.parse_token(*args)
      if args[0].class == String && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:parseToken, [Java::java.lang.String.java_class]).call(args[0]) != nil ? JSON.parse(Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:parseToken, [Java::java.lang.String.java_class]).call(args[0]).encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling parse_token(#{args[0]})"
      end
    end
    # @overload authTime(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [Fixnum]
    def self.auth_time(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:authTime, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling auth_time(#{args[0]})"
      end
    end
    #  Get raw `id_token` string from the principal.
    # @overload rawIdToken(principal)
    #   @param [Hash{String => Object}] principal user principal
    # @return [String] the raw id token string
    def self.raw_id_token(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:rawIdToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw_id_token(#{args[0]})"
      end
    end
    #  Get decoded `access_token` from the principal.
    # @overload accessToken(principal)
    #   @param [Hash{String => Object}] principal user principal
    # @return [Hash{String => Object}] the access token
    def self.access_token(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:accessToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])) != nil ? JSON.parse(Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:accessToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])).encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling access_token(#{args[0]})"
      end
    end
    #  Get raw `access_token` string from the principal.
    # @overload rawAccessToken(principal)
    #   @param [Hash{String => Object}] principal user principal
    # @return [String] the raw access token string
    def self.raw_access_token(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:rawAccessToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw_access_token(#{args[0]})"
      end
    end
    # @overload email(principal)
    #   @param [Hash{String => Object}] principal 
    # @return [String]
    def self.email(*args)
      if args[0].class == Hash && !block_given?
        return Java::IoVertxExtAuthOauth2::KeycloakHelper.java_method(:email, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling email(#{args[0]})"
      end
    end
  end
end
