require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_auth'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.providers.ShopifyAuth
module VertxAuthOauth2
  #  Simplified factory to create an  for Shopify.
  class ShopifyAuth
    # @private
    # @param j_del [::VertxAuthOauth2::ShopifyAuth] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::ShopifyAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ShopifyAuth
    end
    def @@j_api_type.wrap(obj)
      ShopifyAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Providers::ShopifyAuth.java_class
    end
    #  Create a OAuth2Auth provider for Shopify
    # @overload create(vertx,clientId,clientSecret,shop)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] clientId the client id given to you by Shopify
    #   @param [String] clientSecret the client secret given to you by Shopify
    #   @param [String] shop your shop name
    # @overload create(vertx,clientId,clientSecret,shop,httpClientOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] clientId the client id given to you by Shopify
    #   @param [String] clientSecret the client secret given to you by Shopify
    #   @param [String] shop your shop name
    #   @param [Hash{String => Object}] httpClientOptions custom http client options
    # @return [::VertxAuthOauth2::OAuth2Auth]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == String && args[3].class == String && !block_given? && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::ShopifyAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1],args[2],args[3]),::VertxAuthOauth2::OAuth2Auth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == String && args[3].class == String && args[4].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::ShopifyAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreHttp::HttpClientOptions.java_class]).call(args[0].j_del,args[1],args[2],args[3],Java::IoVertxCoreHttp::HttpClientOptions.new(::Vertx::Util::Utils.to_json_object(args[4]))),::VertxAuthOauth2::OAuth2Auth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
  end
end
