require 'vertx/vertx'
require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.circuitbreaker.HystrixMetricHandler
module VertxCircuitBreaker
  #  A Vert.x web handler to expose the circuit breaker to the Hystrix dasbboard. The handler listens to the circuit
  #  breaker notifications sent on the event bus.
  class HystrixMetricHandler
    # @private
    # @param j_del [::VertxCircuitBreaker::HystrixMetricHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCircuitBreaker::HystrixMetricHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HystrixMetricHandler
    end
    def @@j_api_type.wrap(obj)
      HystrixMetricHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_class
    end
    #  Creates the handler.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(vertx,address)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] address the address to listen on the event bus
    # @return [::VertxCircuitBreaker::HystrixMetricHandler] the handler
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxCircuitBreaker::HystrixMetricHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxCircuitBreaker::HystrixMetricHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
  end
end
