require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.config.ConfigRetriever
module VertxConfig
  #  Defines a configuration retriever that read configuration from
  #  
  #  and tracks changes periodically.
  class ConfigRetriever
    # @private
    # @param j_del [::VertxConfig::ConfigRetriever] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxConfig::ConfigRetriever] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ConfigRetriever
    end
    def @@j_api_type.wrap(obj)
      ConfigRetriever.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxConfig::ConfigRetriever.java_class
    end
    #  Gets the last computed configuration.
    # @overload getCachedConfig()
    # @return [Hash{String => Object}] the last configuration
    def get_cached_config
      if !block_given?
        return @j_del.java_method(:getCachedConfig, []).call() != nil ? JSON.parse(@j_del.java_method(:getCachedConfig, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_cached_config()"
      end
    end
    # @overload configStream()
    # @return [::Vertx::ReadStream] the stream of configurations. It's single stream (unicast) and that delivers the last known config and the successors periodically.
    def config_stream
      if !block_given?
        if @cached_config_stream != nil
          return @cached_config_stream
        end
        return @cached_config_stream = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:configStream, []).call(),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling config_stream()"
      end
    end
    #  Creates an instance of the default implementation of the {::VertxConfig::ConfigRetriever}.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vert.x instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance
    #   @param [Hash{String => Object}] options the options, must not be <code>null</code>, must contain the list of configured store.
    # @return [::VertxConfig::ConfigRetriever] the created instance.
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxConfig::ConfigRetriever.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxConfig::ConfigRetriever)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxConfig::ConfigRetriever.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxConfig::ConfigRetrieverOptions.java_class]).call(args[0].j_del,Java::IoVertxConfig::ConfigRetrieverOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxConfig::ConfigRetriever)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Registers a handler that process the configuration before being injected into {::VertxConfig::ConfigRetriever#get_config} or {::VertxConfig::ConfigRetriever#listen}. This allows
    #  the code to customize the configuration.
    # @overload setConfigurationProcessor(processor)
    #   @yield the processor, must not be <code>null</code>. The method must not return <code>null</code>. The returned configuration is used. If the processor does not update the configuration, it must return the input configuration. If the processor throws an exception, the failure is passed to the {::VertxConfig::ConfigRetriever#get_config} handler.
    # @return [self]
    def set_configuration_processor(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:setConfigurationProcessor, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_json_object(yield(event != nil ? JSON.parse(event.encode) : nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_configuration_processor(#{args[0]})"
      end
    end
    #  Closes the retriever.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Registers a listener receiving configuration changes. This method cannot only be called if
    #  the configuration is broadcasted.
    # @overload listen(listener)
    #   @yield the listener
    # @return [void]
    def listen
      if true
        return @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen()"
      end
    end
    #  Reads the configuration from the different 
    #  and computes the final configuration.
    # @overload getConfig(completionHandler)
    #   @yield handler receiving the computed configuration, or a failure if the configuration cannot be retrieved
    # @return [void]
    def get_config
      if true
        if (block_given?)
          return @j_del.java_method(:getConfig, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getConfig, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_config()"
      end
    end
    #  Registers a handler called before every scan. This method is mostly used for logging purpose.
    # @overload setBeforeScanHandler(handler)
    #   @yield the handler, must not be <code>null</code>
    # @return [self]
    def set_before_scan_handler
      if true
        @j_del.java_method(:setBeforeScanHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_before_scan_handler()"
      end
    end
  end
end
